/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.common.Labels;
import io.opentelemetry.api.metrics.DoubleCounter;
import io.opentelemetry.sdk.metrics.AbstractBoundInstrument;
import io.opentelemetry.sdk.metrics.AbstractSynchronousInstrument;
import io.opentelemetry.sdk.metrics.AbstractSynchronousInstrumentBuilder;
import io.opentelemetry.sdk.metrics.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.MeterSharedState;
import io.opentelemetry.sdk.metrics.SynchronousInstrumentAccumulator;
import io.opentelemetry.sdk.metrics.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.common.InstrumentType;
import io.opentelemetry.sdk.metrics.common.InstrumentValueType;

final class DoubleCounterSdk
extends AbstractSynchronousInstrument<BoundInstrument>
implements DoubleCounter {
    private DoubleCounterSdk(InstrumentDescriptor descriptor, SynchronousInstrumentAccumulator<BoundInstrument> accumulator) {
        super(descriptor, accumulator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(double increment, Labels labels) {
        BoundInstrument boundInstrument = (BoundInstrument)this.bind(labels);
        try {
            boundInstrument.add(increment);
        }
        finally {
            boundInstrument.unbind();
        }
    }

    public void add(double increment) {
        this.add(increment, Labels.empty());
    }

    static final class Builder
    extends AbstractSynchronousInstrumentBuilder<Builder>
    implements DoubleCounter.Builder {
        Builder(String name, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState) {
            super(name, InstrumentType.COUNTER, InstrumentValueType.DOUBLE, meterProviderSharedState, meterSharedState);
        }

        @Override
        Builder getThis() {
            return this;
        }

        public DoubleCounterSdk build() {
            return this.buildInstrument(BoundInstrument::new, (x$0, x$1) -> new DoubleCounterSdk((InstrumentDescriptor)x$0, (SynchronousInstrumentAccumulator)x$1));
        }
    }

    static final class BoundInstrument
    extends AbstractBoundInstrument
    implements DoubleCounter.BoundDoubleCounter {
        BoundInstrument(Aggregator aggregator) {
            super(aggregator);
        }

        public void add(double increment) {
            if (increment < 0.0) {
                throw new IllegalArgumentException("Counters can only increase");
            }
            this.recordDouble(increment);
        }
    }
}

