/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.view.AggregationConfiguration;
import io.opentelemetry.sdk.metrics.view.Aggregations;
import io.opentelemetry.sdk.metrics.view.InstrumentSelector;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

class AggregationChooser {
    private static final AggregationConfiguration CUMULATIVE_SUM = AggregationConfiguration.create(Aggregations.sum(), MetricData.AggregationTemporality.CUMULATIVE);
    private static final AggregationConfiguration DELTA_SUMMARY = AggregationConfiguration.create(Aggregations.minMaxSumCount(), MetricData.AggregationTemporality.DELTA);
    private static final AggregationConfiguration CUMULATIVE_LAST_VALUE = AggregationConfiguration.create(Aggregations.lastValue(), MetricData.AggregationTemporality.CUMULATIVE);
    private static final AggregationConfiguration DELTA_LAST_VALUE = AggregationConfiguration.create(Aggregations.lastValue(), MetricData.AggregationTemporality.DELTA);
    private final Map<InstrumentSelector, AggregationConfiguration> configuration = new ConcurrentHashMap<InstrumentSelector, AggregationConfiguration>();

    AggregationChooser() {
    }

    AggregationConfiguration chooseAggregation(InstrumentDescriptor descriptor) {
        ArrayList<Map.Entry<InstrumentSelector, AggregationConfiguration>> possibleMatches = new ArrayList<Map.Entry<InstrumentSelector, AggregationConfiguration>>();
        for (Map.Entry<InstrumentSelector, AggregationConfiguration> entry : this.configuration.entrySet()) {
            InstrumentSelector registeredSelector = entry.getKey();
            if (AggregationChooser.matchesOnType(descriptor, registeredSelector) && AggregationChooser.matchesOnName(descriptor, registeredSelector)) {
                return entry.getValue();
            }
            if (!AggregationChooser.matchesOne(descriptor, registeredSelector)) continue;
            possibleMatches.add(entry);
        }
        if (possibleMatches.isEmpty()) {
            return AggregationChooser.getDefaultSpecification(descriptor);
        }
        return (AggregationConfiguration)((Map.Entry)possibleMatches.get(0)).getValue();
    }

    private static boolean matchesOne(InstrumentDescriptor descriptor, InstrumentSelector selector) {
        if (selector.hasInstrumentNameRegex() && !AggregationChooser.matchesOnName(descriptor, selector)) {
            return false;
        }
        return !selector.hasInstrumentType() || AggregationChooser.matchesOnType(descriptor, selector);
    }

    private static boolean matchesOnType(InstrumentDescriptor descriptor, InstrumentSelector selector) {
        if (selector.instrumentType() == null) {
            return false;
        }
        return selector.instrumentType().equals((Object)descriptor.getType());
    }

    private static boolean matchesOnName(InstrumentDescriptor descriptor, InstrumentSelector registeredSelector) {
        Pattern pattern = registeredSelector.instrumentNamePattern();
        if (pattern == null) {
            return false;
        }
        return pattern.matcher(descriptor.getName()).matches();
    }

    private static AggregationConfiguration getDefaultSpecification(InstrumentDescriptor descriptor) {
        switch (descriptor.getType()) {
            case COUNTER: 
            case UP_DOWN_COUNTER: {
                return CUMULATIVE_SUM;
            }
            case VALUE_RECORDER: {
                return DELTA_SUMMARY;
            }
            case VALUE_OBSERVER: {
                return DELTA_LAST_VALUE;
            }
            case SUM_OBSERVER: 
            case UP_DOWN_SUM_OBSERVER: {
                return CUMULATIVE_LAST_VALUE;
            }
        }
        throw new IllegalArgumentException("Unknown descriptor type: " + (Object)((Object)descriptor.getType()));
    }

    void addView(InstrumentSelector selector, AggregationConfiguration specification) {
        this.configuration.put(selector, specification);
    }
}

