/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.aggregator;

import io.opentelemetry.api.common.Labels;
import io.opentelemetry.sdk.metrics.aggregator.AbstractAggregator;
import io.opentelemetry.sdk.metrics.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.aggregator.AggregatorFactory;
import io.opentelemetry.sdk.metrics.data.MetricData;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

public final class DoubleLastValueAggregator
extends AbstractAggregator {
    @Nullable
    private static final Double DEFAULT_VALUE = null;
    private static final AggregatorFactory AGGREGATOR_FACTORY = DoubleLastValueAggregator::new;
    private final AtomicReference<Double> current = new AtomicReference<Double>(DEFAULT_VALUE);

    public static AggregatorFactory getFactory() {
        return AGGREGATOR_FACTORY;
    }

    @Override
    void doMergeAndReset(Aggregator aggregator) {
        DoubleLastValueAggregator other = (DoubleLastValueAggregator)aggregator;
        other.current.set(this.current.getAndSet(DEFAULT_VALUE));
    }

    @Override
    @Nullable
    public MetricData.Point toPoint(long startEpochNanos, long epochNanos, Labels labels) {
        Double currentValue = this.current.get();
        return currentValue == null ? null : MetricData.DoublePoint.create(startEpochNanos, epochNanos, labels, currentValue);
    }

    @Override
    public void doRecordDouble(double value) {
        this.current.set(value);
    }
}

