/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.sdk.metrics.AggregationChooser;
import io.opentelemetry.sdk.metrics.Batcher;
import io.opentelemetry.sdk.metrics.Batchers;
import io.opentelemetry.sdk.metrics.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.MeterSharedState;
import io.opentelemetry.sdk.metrics.view.Aggregation;
import io.opentelemetry.sdk.metrics.view.AggregationConfiguration;
import io.opentelemetry.sdk.metrics.view.InstrumentSelector;

class ViewRegistry {
    private final AggregationChooser aggregationChooser;

    ViewRegistry() {
        this(new AggregationChooser());
    }

    ViewRegistry(AggregationChooser aggregationChooser) {
        this.aggregationChooser = aggregationChooser;
    }

    void registerView(InstrumentSelector selector, AggregationConfiguration specification) {
        this.aggregationChooser.addView(selector, specification);
    }

    Batcher createBatcher(MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, InstrumentDescriptor descriptor) {
        AggregationConfiguration specification = this.aggregationChooser.chooseAggregation(descriptor);
        Aggregation aggregation = specification.aggregation();
        if (AggregationConfiguration.Temporality.CUMULATIVE == specification.temporality()) {
            return Batchers.getCumulativeAllLabels(descriptor, meterProviderSharedState, meterSharedState, aggregation);
        }
        if (AggregationConfiguration.Temporality.DELTA == specification.temporality()) {
            return Batchers.getDeltaAllLabels(descriptor, meterProviderSharedState, meterSharedState, aggregation);
        }
        throw new IllegalStateException("unsupported Temporality: " + (Object)((Object)specification.temporality()));
    }
}

