/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.common.Labels;
import io.opentelemetry.metrics.DoubleCounter;
import io.opentelemetry.sdk.metrics.AbstractBoundInstrument;
import io.opentelemetry.sdk.metrics.AbstractInstrument;
import io.opentelemetry.sdk.metrics.AbstractSynchronousInstrument;
import io.opentelemetry.sdk.metrics.ActiveBatcher;
import io.opentelemetry.sdk.metrics.Batcher;
import io.opentelemetry.sdk.metrics.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.MeterSdk;
import io.opentelemetry.sdk.metrics.MeterSharedState;
import io.opentelemetry.sdk.metrics.common.InstrumentType;
import io.opentelemetry.sdk.metrics.common.InstrumentValueType;

final class DoubleCounterSdk
extends AbstractSynchronousInstrument<BoundInstrument>
implements DoubleCounter {
    private DoubleCounterSdk(InstrumentDescriptor descriptor, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, Batcher batcher) {
        super(descriptor, meterProviderSharedState, meterSharedState, new ActiveBatcher(batcher));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(double increment, Labels labels) {
        BoundInstrument boundInstrument = (BoundInstrument)this.bind(labels);
        try {
            boundInstrument.add(increment);
        }
        finally {
            boundInstrument.unbind();
        }
    }

    public void add(double increment) {
        this.add(increment, Labels.empty());
    }

    @Override
    BoundInstrument newBinding(Batcher batcher) {
        return new BoundInstrument(batcher);
    }

    static final class Builder
    extends AbstractInstrument.Builder<Builder>
    implements DoubleCounter.Builder {
        Builder(String name, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, MeterSdk meterSdk) {
            super(name, meterProviderSharedState, meterSharedState, meterSdk);
        }

        @Override
        Builder getThis() {
            return this;
        }

        public DoubleCounterSdk build() {
            InstrumentDescriptor instrumentDescriptor = this.getInstrumentDescriptor(InstrumentType.COUNTER, InstrumentValueType.DOUBLE);
            return this.register(new DoubleCounterSdk(instrumentDescriptor, this.getMeterProviderSharedState(), this.getMeterSharedState(), this.getBatcher(instrumentDescriptor)));
        }
    }

    static final class BoundInstrument
    extends AbstractBoundInstrument
    implements DoubleCounter.BoundDoubleCounter {
        BoundInstrument(Batcher batcher) {
            super(batcher.getAggregator());
        }

        public void add(double increment) {
            if (increment < 0.0) {
                throw new IllegalArgumentException("Counters can only increase");
            }
            this.recordDouble(increment);
        }
    }
}

