/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.common.Labels;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.metrics.AbstractBoundInstrument;
import io.opentelemetry.sdk.metrics.AbstractInstrument;
import io.opentelemetry.sdk.metrics.ActiveBatcher;
import io.opentelemetry.sdk.metrics.Batcher;
import io.opentelemetry.sdk.metrics.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.MeterSharedState;
import io.opentelemetry.sdk.metrics.MetricsProcessor;
import io.opentelemetry.sdk.metrics.data.MetricData;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

abstract class AbstractSynchronousInstrument<B extends AbstractBoundInstrument>
extends AbstractInstrument {
    private final ConcurrentHashMap<Labels, B> boundLabels = new ConcurrentHashMap();
    private final ReentrantLock collectLock = new ReentrantLock();

    AbstractSynchronousInstrument(InstrumentDescriptor descriptor, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, ActiveBatcher activeBatcher) {
        super(descriptor, meterProviderSharedState, meterSharedState, activeBatcher);
    }

    public B bind(Labels labels) {
        AbstractBoundInstrument oldBound;
        Objects.requireNonNull(labels, "labels");
        for (MetricsProcessor p : this.getMeterSharedState().getMetricsProcessors()) {
            labels = p.onLabelsBound(Context.current(), this, labels);
        }
        AbstractBoundInstrument binding = (AbstractBoundInstrument)this.boundLabels.get(labels);
        if (binding != null && binding.bind()) {
            return (B)binding;
        }
        binding = this.newBinding(this.getActiveBatcher());
        while ((oldBound = this.boundLabels.putIfAbsent(labels, binding)) != null) {
            if (oldBound.bind()) {
                return (B)oldBound;
            }
            this.boundLabels.remove(labels, oldBound);
        }
        return (B)binding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final List<MetricData> collectAll() {
        this.collectLock.lock();
        try {
            ActiveBatcher batcher = this.getActiveBatcher();
            for (Map.Entry<Labels, B> entry : this.boundLabels.entrySet()) {
                boolean unmappedEntry = ((AbstractBoundInstrument)entry.getValue()).tryUnmap();
                if (unmappedEntry) {
                    this.boundLabels.remove(entry.getKey(), entry.getValue());
                }
                batcher.batch(entry.getKey(), ((AbstractBoundInstrument)entry.getValue()).getAggregator(), unmappedEntry);
            }
            List<MetricData> list = batcher.completeCollectionCycle();
            return list;
        }
        finally {
            this.collectLock.unlock();
        }
    }

    abstract B newBinding(Batcher var1);
}

