/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.resources;

import com.google.auto.value.AutoValue;
import io.opentelemetry.sdk.common.export.ConfigBuilder;
import io.opentelemetry.sdk.resources.AutoValue_ResourcesConfig;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;

@AutoValue
@Immutable
public abstract class ResourcesConfig {
    private static final ResourcesConfig DEFAULT = ResourcesConfig.builder().build();

    public static ResourcesConfig getDefault() {
        return DEFAULT;
    }

    public abstract Set<String> getDisabledResourceProviders();

    public static Builder builder() {
        return new AutoValue_ResourcesConfig.Builder().setDisabledResourceProviders(Collections.emptySet());
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder
    extends ConfigBuilder<Builder> {
        private static final String OTEL_JAVA_DISABLED_RESOURCES_PROVIDERS = "otel.java.disabled.resource_providers";

        Builder() {
        }

        @Override
        protected Builder fromConfigMap(Map<String, String> configMap, ConfigBuilder.NamingConvention namingConvention) {
            String stringValue = Builder.getStringProperty(OTEL_JAVA_DISABLED_RESOURCES_PROVIDERS, configMap = namingConvention.normalize(configMap));
            if (stringValue != null) {
                this.setDisabledResourceProviders(Collections.unmodifiableSet(Arrays.stream(stringValue.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toSet())));
            }
            return this;
        }

        public abstract Builder setDisabledResourceProviders(Set<String> var1);

        abstract ResourcesConfig autoBuild();

        public ResourcesConfig build() {
            ResourcesConfig resourcesConfig = this.autoBuild();
            Objects.requireNonNull(resourcesConfig.getDisabledResourceProviders(), "disabledResourceProviders");
            return resourcesConfig;
        }
    }
}

