/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.resources;

import com.google.common.annotations.VisibleForTesting;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.sdk.common.export.ConfigBuilder;
import io.opentelemetry.sdk.resources.Resource;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class EnvAutodetectResource {
    private static final String ATTRIBUTE_LIST_SPLITTER = ",";
    private static final String ATTRIBUTE_KEY_VALUE_SPLITTER = "=";

    private EnvAutodetectResource() {
    }

    @VisibleForTesting
    static Attributes parseResourceAttributes(@Nullable String rawEnvAttributes) {
        String[] rawAttributes;
        if (rawEnvAttributes == null) {
            return Attributes.empty();
        }
        AttributesBuilder attrBuilders = Attributes.builder();
        for (String rawAttribute : rawAttributes = rawEnvAttributes.split(ATTRIBUTE_LIST_SPLITTER, -1)) {
            String[] keyValuePair = rawAttribute.split(ATTRIBUTE_KEY_VALUE_SPLITTER, -1);
            if (keyValuePair.length != 2) continue;
            attrBuilders.put(keyValuePair[0].trim(), keyValuePair[1].trim().replaceAll("^\"|\"$", ""));
        }
        return attrBuilders.build();
    }

    protected static class Builder
    extends ConfigBuilder<Builder> {
        private static final String OTEL_RESOURCE_ATTRIBUTES_KEY = "otel.resource.attributes";
        private String envAttributes;

        protected Builder() {
        }

        @Override
        protected Builder fromConfigMap(Map<String, String> configMap, ConfigBuilder.NamingConvention namingConvention) {
            String envAttributesValue = Builder.getStringProperty(OTEL_RESOURCE_ATTRIBUTES_KEY, configMap = namingConvention.normalize(configMap));
            if (envAttributesValue != null) {
                this.setEnvAttributes(envAttributesValue);
            }
            return this;
        }

        public Builder setEnvAttributes(String envAttributes) {
            this.envAttributes = envAttributes;
            return this;
        }

        public Resource build() {
            return Resource.create(EnvAutodetectResource.parseResourceAttributes(this.envAttributes));
        }
    }
}

