/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.extensions.trace.propagation;

import io.opentelemetry.extensions.trace.propagation.StringUtils;
import io.opentelemetry.trace.SpanContext;
import io.opentelemetry.trace.SpanId;
import io.opentelemetry.trace.TraceFlags;
import io.opentelemetry.trace.TraceId;
import io.opentelemetry.trace.TraceState;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.Immutable;

@Immutable
final class Common {
    private static final Logger logger = Logger.getLogger(Common.class.getName());
    static final String TRUE_INT = "1";
    static final String FALSE_INT = "0";
    static final int MAX_TRACE_ID_LENGTH = TraceId.getHexLength();
    static final int MIN_TRACE_ID_LENGTH = TraceId.getSize();
    private static final byte SAMPLED = TraceFlags.getSampled();
    private static final byte NOT_SAMPLED = TraceFlags.getDefault();

    private Common() {
    }

    static SpanContext buildSpanContext(String traceId, String spanId, String sampled) {
        try {
            byte traceFlags = TRUE_INT.equals(sampled) || Boolean.parseBoolean(sampled) ? SAMPLED : NOT_SAMPLED;
            return SpanContext.createFromRemoteParent((String)StringUtils.padLeft(traceId, MAX_TRACE_ID_LENGTH), (String)spanId, (byte)traceFlags, (TraceState)TraceState.getDefault());
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Error parsing header. Returning INVALID span context.", e);
            return SpanContext.getInvalid();
        }
    }

    static boolean isTraceIdValid(String value) {
        return !StringUtils.isNullOrEmpty(value) && (value.length() == MIN_TRACE_ID_LENGTH || value.length() == MAX_TRACE_ID_LENGTH) && TraceId.isValid((CharSequence)StringUtils.padLeft(value, TraceId.getHexLength()));
    }

    static boolean isSpanIdValid(String value) {
        return !StringUtils.isNullOrEmpty(value) && SpanId.isValid((String)value);
    }
}

