/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.extensions.trace.propagation;

import io.grpc.Context;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.extensions.trace.propagation.B3PropagatorExtractor;
import io.opentelemetry.extensions.trace.propagation.Common;
import io.opentelemetry.extensions.trace.propagation.StringUtils;
import io.opentelemetry.trace.DefaultSpan;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.SpanContext;
import io.opentelemetry.trace.TracingContextUtils;
import java.util.Objects;
import java.util.logging.Logger;
import javax.annotation.concurrent.Immutable;

@Immutable
final class B3PropagatorExtractorSingleHeader
implements B3PropagatorExtractor {
    private static final Logger logger = Logger.getLogger(B3PropagatorExtractorSingleHeader.class.getName());

    B3PropagatorExtractorSingleHeader() {
    }

    @Override
    public <C> Context extract(Context context, C carrier, TextMapPropagator.Getter<C> getter) {
        Objects.requireNonNull(carrier, "carrier");
        Objects.requireNonNull(getter, "getter");
        SpanContext spanContext = B3PropagatorExtractorSingleHeader.getSpanContextFromSingleHeader(carrier, getter);
        if (!spanContext.isValid()) {
            return context;
        }
        return TracingContextUtils.withSpan((Span)DefaultSpan.create((SpanContext)spanContext), (Context)context);
    }

    private static <C> SpanContext getSpanContextFromSingleHeader(C carrier, TextMapPropagator.Getter<C> getter) {
        String value = getter.get(carrier, "b3");
        if (StringUtils.isNullOrEmpty(value)) {
            return SpanContext.getInvalid();
        }
        String[] parts = value.split("-");
        if (parts.length < 2 || parts.length > 4) {
            logger.fine("Invalid combined header 'b3. Returning INVALID span context.");
            return SpanContext.getInvalid();
        }
        String traceId = parts[0];
        if (!Common.isTraceIdValid(traceId)) {
            logger.fine("Invalid TraceId in B3 header: b3. Returning INVALID span context.");
            return SpanContext.getInvalid();
        }
        String spanId = parts[1];
        if (!Common.isSpanIdValid(spanId)) {
            logger.fine("Invalid SpanId in B3 header: b3. Returning INVALID span context.");
            return SpanContext.getInvalid();
        }
        String sampled = parts.length >= 3 ? parts[2] : null;
        return Common.buildSpanContext(traceId, spanId, sampled);
    }
}

