/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.extensions.trace.propagation;

import io.opentelemetry.extensions.trace.propagation.StringUtils;
import io.opentelemetry.trace.SpanContext;
import io.opentelemetry.trace.SpanId;
import io.opentelemetry.trace.TraceFlags;
import io.opentelemetry.trace.TraceId;
import io.opentelemetry.trace.TraceState;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.Immutable;

@Immutable
final class Common {
    private static final Logger logger = Logger.getLogger(Common.class.getName());
    static final String TRUE_INT = "1";
    static final String FALSE_INT = "0";
    static final int MAX_TRACE_ID_LENGTH = 2 * TraceId.getSize();
    static final int MAX_SPAN_ID_LENGTH = 2 * SpanId.getSize();
    static final int MIN_TRACE_ID_LENGTH = TraceId.getSize();
    private static final TraceFlags SAMPLED_FLAGS = TraceFlags.builder().setIsSampled(true).build();
    private static final TraceFlags NOT_SAMPLED_FLAGS = TraceFlags.builder().setIsSampled(false).build();

    private Common() {
    }

    static SpanContext buildSpanContext(String traceId, String spanId, String sampled) {
        try {
            TraceFlags traceFlags = TRUE_INT.equals(sampled) || Boolean.parseBoolean(sampled) ? SAMPLED_FLAGS : NOT_SAMPLED_FLAGS;
            return SpanContext.createFromRemoteParent((TraceId)TraceId.fromLowerBase16((CharSequence)StringUtils.padLeft(traceId, MAX_TRACE_ID_LENGTH), (int)0), (SpanId)SpanId.fromLowerBase16((CharSequence)spanId, (int)0), (TraceFlags)traceFlags, (TraceState)TraceState.getDefault());
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Error parsing header. Returning INVALID span context.", e);
            return SpanContext.getInvalid();
        }
    }

    private static boolean isHex(String value) {
        for (int i = 0; i < value.length(); ++i) {
            if (Character.digit(value.charAt(i), 16) != -1) continue;
            return false;
        }
        return true;
    }

    static boolean isTraceIdValid(String value) {
        return !StringUtils.isNullOrEmpty(value) && (value.length() == MIN_TRACE_ID_LENGTH || value.length() == MAX_TRACE_ID_LENGTH) && Common.isHex(value);
    }

    static boolean isSpanIdValid(String value) {
        return !StringUtils.isNullOrEmpty(value) && value.length() == MAX_SPAN_ID_LENGTH && Common.isHex(value);
    }
}

