/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.extensions.trace.propagation;

import io.grpc.Context;
import io.opentelemetry.context.propagation.HttpTextFormat;
import io.opentelemetry.extensions.trace.propagation.B3PropagatorExtractor;
import io.opentelemetry.extensions.trace.propagation.B3PropagatorExtractorMultipleHeaders;
import io.opentelemetry.extensions.trace.propagation.B3PropagatorExtractorSingleHeader;
import io.opentelemetry.extensions.trace.propagation.B3PropagatorInjector;
import io.opentelemetry.extensions.trace.propagation.B3PropagatorInjectorMultipleHeaders;
import io.opentelemetry.extensions.trace.propagation.B3PropagatorInjectorSingleHeader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public class B3Propagator
implements HttpTextFormat {
    static final String TRACE_ID_HEADER = "X-B3-TraceId";
    static final String SPAN_ID_HEADER = "X-B3-SpanId";
    static final String SAMPLED_HEADER = "X-B3-Sampled";
    static final String COMBINED_HEADER = "b3";
    static final String COMBINED_HEADER_DELIMITER = "-";
    static final char COMBINED_HEADER_DELIMITER_CHAR = '-';
    static final char IS_SAMPLED = '1';
    static final char NOT_SAMPLED = '0';
    private static final List<String> FIELDS = Collections.unmodifiableList(Arrays.asList("X-B3-TraceId", "X-B3-SpanId", "X-B3-Sampled"));
    private final B3PropagatorInjector b3PropagatorInjector;
    private final B3PropagatorExtractor b3PropagatorExtractor;
    private static final B3Propagator SINGLE_HEADER = new B3Propagator(new B3PropagatorInjectorSingleHeader(), new B3PropagatorExtractorSingleHeader());
    private static final B3Propagator MULTI_HEADER = new B3Propagator(new B3PropagatorInjectorMultipleHeaders(), new B3PropagatorExtractorMultipleHeaders());

    public static B3Propagator getSingleHeaderPropagator() {
        return SINGLE_HEADER;
    }

    public static B3Propagator getMultipleHeaderPropagator() {
        return MULTI_HEADER;
    }

    private B3Propagator(B3PropagatorInjector b3PropagatorInjector, B3PropagatorExtractor b3PropagatorExtractor) {
        this.b3PropagatorInjector = b3PropagatorInjector;
        this.b3PropagatorExtractor = b3PropagatorExtractor;
    }

    public List<String> fields() {
        return FIELDS;
    }

    public <C> void inject(Context context, C carrier, HttpTextFormat.Setter<C> setter) {
        this.b3PropagatorInjector.inject(context, carrier, setter);
    }

    public <C> Context extract(Context context, C carrier, HttpTextFormat.Getter<C> getter) {
        return this.b3PropagatorExtractor.extract(context, carrier, getter);
    }
}

