/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.extensions.trace.propagation;

import io.grpc.Context;
import io.opentelemetry.context.propagation.HttpTextFormat;
import io.opentelemetry.extensions.trace.propagation.Common;
import io.opentelemetry.trace.DefaultSpan;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.SpanContext;
import io.opentelemetry.trace.TracingContextUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public class OtTracerPropagator
implements HttpTextFormat {
    static final String TRACE_ID_HEADER = "ot-tracer-traceid";
    static final String SPAN_ID_HEADER = "ot-tracer-spanid";
    static final String SAMPLED_HEADER = "ot-tracer-sampled";
    private static final List<String> FIELDS = Collections.unmodifiableList(Arrays.asList("ot-tracer-traceid", "ot-tracer-spanid", "ot-tracer-sampled"));
    private static final OtTracerPropagator INSTANCE = new OtTracerPropagator();

    private OtTracerPropagator() {
    }

    public static OtTracerPropagator getInstance() {
        return INSTANCE;
    }

    public List<String> fields() {
        return FIELDS;
    }

    public <C> void inject(Context context, C carrier, HttpTextFormat.Setter<C> setter) {
        if (context == null || setter == null) {
            return;
        }
        Span span = TracingContextUtils.getSpanWithoutDefault((Context)context);
        if (span == null) {
            return;
        }
        SpanContext spanContext = span.getContext();
        if (!spanContext.isValid()) {
            return;
        }
        setter.set(carrier, TRACE_ID_HEADER, spanContext.getTraceId().toLowerBase16());
        setter.set(carrier, SPAN_ID_HEADER, spanContext.getSpanId().toLowerBase16());
        setter.set(carrier, SAMPLED_HEADER, String.valueOf(spanContext.getTraceFlags().isSampled()));
    }

    public <C> Context extract(Context context, C carrier, HttpTextFormat.Getter<C> getter) {
        String sampled;
        String spanId;
        if (context == null || getter == null) {
            return context;
        }
        String traceId = getter.get(carrier, TRACE_ID_HEADER);
        SpanContext spanContext = OtTracerPropagator.buildSpanContext(traceId, spanId = getter.get(carrier, SPAN_ID_HEADER), sampled = getter.get(carrier, SAMPLED_HEADER));
        if (!spanContext.isValid()) {
            return context;
        }
        return TracingContextUtils.withSpan((Span)DefaultSpan.create((SpanContext)spanContext), (Context)context);
    }

    static SpanContext buildSpanContext(String traceId, String spanId, String sampled) {
        if (!Common.isTraceIdValid(traceId) || !Common.isSpanIdValid(spanId)) {
            return SpanContext.getInvalid();
        }
        return Common.buildSpanContext(traceId, spanId, sampled);
    }
}

