/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.extensions.trace.propagation;

import io.grpc.Context;
import io.opentelemetry.context.propagation.HttpTextFormat;
import io.opentelemetry.trace.DefaultSpan;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.SpanContext;
import io.opentelemetry.trace.SpanId;
import io.opentelemetry.trace.TraceFlags;
import io.opentelemetry.trace.TraceId;
import io.opentelemetry.trace.TraceState;
import io.opentelemetry.trace.TracingContextUtils;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class AwsXRayPropagator
implements HttpTextFormat {
    static final String TRACE_HEADER_KEY = "X-Amzn-Trace-Id";
    private static final Logger logger = Logger.getLogger(AwsXRayPropagator.class.getName());
    private static final char TRACE_HEADER_DELIMITER = ';';
    private static final char KV_DELIMITER = '=';
    private static final String TRACE_ID_KEY = "Root";
    private static final int TRACE_ID_LENGTH = 35;
    private static final String TRACE_ID_VERSION = "1";
    private static final char TRACE_ID_DELIMITER = '-';
    private static final int TRACE_ID_DELIMITER_INDEX_1 = 1;
    private static final int TRACE_ID_DELIMITER_INDEX_2 = 10;
    private static final int TRACE_ID_FIRST_PART_LENGTH = 8;
    private static final String PARENT_ID_KEY = "Parent";
    private static final int PARENT_ID_LENGTH = 16;
    private static final String SAMPLED_FLAG_KEY = "Sampled";
    private static final int SAMPLED_FLAG_LENGTH = 1;
    private static final char IS_SAMPLED = '1';
    private static final char NOT_SAMPLED = '0';
    private static final List<String> FIELDS = Collections.singletonList("X-Amzn-Trace-Id");

    public List<String> fields() {
        return FIELDS;
    }

    public <C> void inject(Context context, @Nullable C carrier, HttpTextFormat.Setter<C> setter) {
        Objects.requireNonNull(context, "context");
        Objects.requireNonNull(setter, "setter");
        Span span = TracingContextUtils.getSpan((Context)context);
        if (!span.getContext().isValid()) {
            return;
        }
        SpanContext spanContext = span.getContext();
        String otTraceId = spanContext.getTraceId().toLowerBase16();
        String xrayTraceId = "1-" + otTraceId.substring(0, 8) + '-' + otTraceId.substring(8);
        String parentId = spanContext.getSpanId().toLowerBase16();
        char samplingFlag = spanContext.getTraceFlags().isSampled() ? (char)'1' : '0';
        String traceHeader = "Root=" + xrayTraceId + ';' + PARENT_ID_KEY + '=' + parentId + ';' + SAMPLED_FLAG_KEY + '=' + samplingFlag;
        setter.set(carrier, TRACE_HEADER_KEY, traceHeader);
    }

    public <C> Context extract(Context context, C carrier, HttpTextFormat.Getter<C> getter) {
        Objects.requireNonNull(carrier, "carrier");
        Objects.requireNonNull(getter, "getter");
        SpanContext spanContext = AwsXRayPropagator.getSpanContextFromHeader(carrier, getter);
        if (!spanContext.isValid()) {
            return context;
        }
        return TracingContextUtils.withSpan((Span)DefaultSpan.create((SpanContext)spanContext), (Context)context);
    }

    private static <C> SpanContext getSpanContextFromHeader(C carrier, HttpTextFormat.Getter<C> getter) {
        String traceHeader = getter.get(carrier, TRACE_HEADER_KEY);
        if (traceHeader == null || traceHeader.isEmpty()) {
            return SpanContext.getInvalid();
        }
        TraceId traceId = TraceId.getInvalid();
        SpanId spanId = SpanId.getInvalid();
        TraceFlags traceFlags = TraceFlags.getDefault();
        int pos = 0;
        while (pos < traceHeader.length()) {
            String part;
            int delimiterIndex = traceHeader.indexOf(59, pos);
            if (delimiterIndex >= 0) {
                part = traceHeader.substring(pos, delimiterIndex);
                pos = delimiterIndex + 1;
            } else {
                part = traceHeader.substring(pos);
                pos = traceHeader.length();
            }
            String trimmedPart = part.trim();
            int equalsIndex = trimmedPart.indexOf(61);
            if (equalsIndex < 0) {
                logger.fine("Error parsing X-Ray trace header. Invalid key value pair: " + part + " Returning INVALID span context.");
                return SpanContext.getInvalid();
            }
            String value = trimmedPart.substring(equalsIndex + 1);
            if (trimmedPart.startsWith(TRACE_ID_KEY)) {
                traceId = AwsXRayPropagator.parseTraceId(value);
                continue;
            }
            if (trimmedPart.startsWith(PARENT_ID_KEY)) {
                spanId = AwsXRayPropagator.parseSpanId(value);
                continue;
            }
            if (!trimmedPart.startsWith(SAMPLED_FLAG_KEY)) continue;
            traceFlags = AwsXRayPropagator.parseTraceFlag(value);
        }
        if (!traceId.isValid()) {
            logger.fine("Invalid TraceId in X-Ray trace header: 'X-Amzn-Trace-Id' with value " + traceHeader + "'. Returning INVALID span context.");
            return SpanContext.getInvalid();
        }
        if (!spanId.isValid()) {
            logger.fine("Invalid ParentId in X-Ray trace header: 'X-Amzn-Trace-Id' with value " + traceHeader + "'. Returning INVALID span context.");
            return SpanContext.getInvalid();
        }
        if (traceFlags == null) {
            logger.fine("Invalid Sampling flag in X-Ray trace header: 'X-Amzn-Trace-Id' with value " + traceHeader + "'. Returning INVALID span context.");
            return SpanContext.getInvalid();
        }
        return SpanContext.createFromRemoteParent((TraceId)traceId, (SpanId)spanId, (TraceFlags)traceFlags, (TraceState)TraceState.getDefault());
    }

    private static TraceId parseTraceId(String xrayTraceId) {
        if (xrayTraceId.length() != 35) {
            return TraceId.getInvalid();
        }
        if (!xrayTraceId.startsWith(TRACE_ID_VERSION)) {
            return TraceId.getInvalid();
        }
        if (xrayTraceId.charAt(1) != '-' || xrayTraceId.charAt(10) != '-') {
            return TraceId.getInvalid();
        }
        String epochPart = xrayTraceId.substring(2, 10);
        String uniquePart = xrayTraceId.substring(11, 35);
        try {
            return TraceId.fromLowerBase16((CharSequence)(epochPart + uniquePart), (int)0);
        }
        catch (Exception e) {
            return TraceId.getInvalid();
        }
    }

    private static SpanId parseSpanId(String xrayParentId) {
        if (xrayParentId.length() != 16) {
            return SpanId.getInvalid();
        }
        try {
            return SpanId.fromLowerBase16((CharSequence)xrayParentId, (int)0);
        }
        catch (Exception e) {
            return SpanId.getInvalid();
        }
    }

    @Nullable
    private static TraceFlags parseTraceFlag(String xraySampledFlag) {
        if (xraySampledFlag.length() != 1) {
            return null;
        }
        char flag = xraySampledFlag.charAt(0);
        if (flag == '1') {
            return TraceFlags.builder().setIsSampled(true).build();
        }
        if (flag == '0') {
            return TraceFlags.builder().setIsSampled(false).build();
        }
        return null;
    }
}

