/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.extensions.trace.propagation;

import io.grpc.Context;
import io.opentelemetry.context.propagation.HttpTextFormat;
import io.opentelemetry.trace.TracingContextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class TraceMultiPropagator
implements HttpTextFormat {
    private final HttpTextFormat[] propagators;
    private final List<String> propagatorsFields;

    private TraceMultiPropagator(List<HttpTextFormat> propagatorList) {
        this.propagators = new HttpTextFormat[propagatorList.size()];
        propagatorList.toArray(this.propagators);
        ArrayList fields = new ArrayList();
        for (HttpTextFormat propagator : this.propagators) {
            fields.addAll(propagator.fields());
        }
        this.propagatorsFields = Collections.unmodifiableList(fields);
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<String> fields() {
        return this.propagatorsFields;
    }

    public <C> void inject(Context context, C carrier, HttpTextFormat.Setter<C> setter) {
        for (int i = this.propagators.length - 1; i >= 0; --i) {
            this.propagators[i].inject(context, carrier, setter);
        }
    }

    public <C> Context extract(Context context, C carrier, HttpTextFormat.Getter<C> getter) {
        for (int i = this.propagators.length - 1; i >= 0 && !TraceMultiPropagator.isSpanContextExtracted(context = this.propagators[i].extract(context, carrier, getter)); --i) {
        }
        return context;
    }

    private static boolean isSpanContextExtracted(Context context) {
        return TracingContextUtils.getSpanWithoutDefault((Context)context) != null;
    }

    public static class Builder {
        private final List<HttpTextFormat> propagators = new ArrayList<HttpTextFormat>();

        private Builder() {
        }

        public Builder addPropagator(HttpTextFormat propagator) {
            Objects.requireNonNull(propagator, "propagator");
            this.propagators.add(propagator);
            return this;
        }

        public TraceMultiPropagator build() {
            return new TraceMultiPropagator(this.propagators);
        }
    }
}

