/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.extensions.trace.propagation;

import io.grpc.Context;
import io.opentelemetry.context.propagation.HttpTextFormat;
import io.opentelemetry.extensions.trace.propagation.B3PropagatorExtractor;
import io.opentelemetry.trace.DefaultSpan;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.SpanContext;
import io.opentelemetry.trace.TracingContextUtils;
import java.util.Objects;
import java.util.logging.Logger;
import javax.annotation.concurrent.Immutable;

@Immutable
final class B3PropagatorExtractorMultipleHeaders
implements B3PropagatorExtractor {
    private static final Logger logger = Logger.getLogger(B3PropagatorExtractorMultipleHeaders.class.getName());

    B3PropagatorExtractorMultipleHeaders() {
    }

    @Override
    public <C> Context extract(Context context, C carrier, HttpTextFormat.Getter<C> getter) {
        Objects.requireNonNull(carrier, "carrier");
        Objects.requireNonNull(getter, "getter");
        SpanContext spanContext = B3PropagatorExtractorMultipleHeaders.getSpanContextFromMultipleHeaders(carrier, getter);
        if (!spanContext.isValid()) {
            return context;
        }
        return TracingContextUtils.withSpan((Span)DefaultSpan.create((SpanContext)spanContext), (Context)context);
    }

    private static <C> SpanContext getSpanContextFromMultipleHeaders(C carrier, HttpTextFormat.Getter<C> getter) {
        String traceId = getter.get(carrier, "X-B3-TraceId");
        if (!B3PropagatorExtractor.Util.isTraceIdValid(traceId)) {
            logger.info("Invalid TraceId in B3 header: X-B3-TraceId'. Returning INVALID span context.");
            return SpanContext.getInvalid();
        }
        String spanId = getter.get(carrier, "X-B3-SpanId");
        if (!B3PropagatorExtractor.Util.isSpanIdValid(spanId)) {
            logger.info("Invalid SpanId in B3 header: X-B3-SpanId'. Returning INVALID span context.");
            return SpanContext.getInvalid();
        }
        String sampled = getter.get(carrier, "X-B3-Sampled");
        return B3PropagatorExtractor.Util.buildSpanContext(traceId, spanId, sampled);
    }
}

