/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.extensions.trace.propagation;

import io.grpc.Context;
import io.opentelemetry.context.propagation.HttpTextFormat;
import io.opentelemetry.extensions.trace.propagation.B3Propagator;
import io.opentelemetry.extensions.trace.propagation.StringUtils;
import io.opentelemetry.trace.SpanContext;
import io.opentelemetry.trace.SpanId;
import io.opentelemetry.trace.TraceFlags;
import io.opentelemetry.trace.TraceId;
import io.opentelemetry.trace.TraceState;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.Immutable;

@Immutable
interface B3PropagatorExtractor {
    public <C> Context extract(Context var1, C var2, HttpTextFormat.Getter<C> var3);

    @Immutable
    public static class Util {
        private static final Logger logger = Logger.getLogger(Util.class.getName());
        private static final TraceFlags SAMPLED_FLAGS = TraceFlags.builder().setIsSampled(true).build();
        private static final TraceFlags NOT_SAMPLED_FLAGS = TraceFlags.builder().setIsSampled(false).build();

        private Util() {
        }

        static SpanContext buildSpanContext(String traceId, String spanId, String sampled) {
            try {
                TraceFlags traceFlags = "1".equals(sampled) || Boolean.parseBoolean(sampled) ? SAMPLED_FLAGS : NOT_SAMPLED_FLAGS;
                return SpanContext.createFromRemoteParent((TraceId)TraceId.fromLowerBase16((CharSequence)StringUtils.padLeft(traceId, B3Propagator.MAX_TRACE_ID_LENGTH), (int)0), (SpanId)SpanId.fromLowerBase16((CharSequence)spanId, (int)0), (TraceFlags)traceFlags, (TraceState)TraceState.getDefault());
            }
            catch (Exception e) {
                logger.log(Level.INFO, "Error parsing B3 header. Returning INVALID span context.", e);
                return SpanContext.getInvalid();
            }
        }

        static boolean isTraceIdValid(String value) {
            return !StringUtils.isNullOrEmpty(value) && value.length() <= B3Propagator.MAX_TRACE_ID_LENGTH;
        }

        static boolean isSpanIdValid(String value) {
            return !StringUtils.isNullOrEmpty(value) && value.length() <= B3Propagator.MAX_SPAN_ID_LENGTH;
        }
    }
}

