/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.extension.trace.propagation;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.extension.trace.propagation.B3Propagator;
import io.opentelemetry.extension.trace.propagation.B3PropagatorExtractor;
import io.opentelemetry.extension.trace.propagation.Common;
import io.opentelemetry.extension.trace.propagation.StringUtils;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import javax.annotation.concurrent.Immutable;

@Immutable
final class B3PropagatorExtractorSingleHeader
implements B3PropagatorExtractor {
    private static final Logger logger = Logger.getLogger(B3PropagatorExtractorSingleHeader.class.getName());

    B3PropagatorExtractorSingleHeader() {
    }

    @Override
    public <C> Optional<Context> extract(Context context, C carrier, TextMapGetter<C> getter) {
        Objects.requireNonNull(carrier, "carrier");
        Objects.requireNonNull(getter, "getter");
        return B3PropagatorExtractorSingleHeader.extractSpanContextFromSingleHeader(context, carrier, getter);
    }

    private static <C> Optional<Context> extractSpanContextFromSingleHeader(Context context, C carrier, TextMapGetter<C> getter) {
        String sampled;
        String value = getter.get(carrier, "b3");
        if (StringUtils.isNullOrEmpty(value)) {
            return Optional.empty();
        }
        String[] parts = value.split("-");
        if (parts.length < 2 || parts.length > 4) {
            logger.fine("Invalid combined header 'b3. Returning INVALID span context.");
            return Optional.empty();
        }
        String traceId = parts[0];
        if (!Common.isTraceIdValid(traceId)) {
            logger.fine("Invalid TraceId in B3 header: b3. Returning INVALID span context.");
            return Optional.empty();
        }
        String spanId = parts[1];
        if (!Common.isSpanIdValid(spanId)) {
            logger.fine("Invalid SpanId in B3 header: b3. Returning INVALID span context.");
            return Optional.empty();
        }
        String string = sampled = parts.length >= 3 ? parts[2] : null;
        if ("d".equals(sampled)) {
            return Optional.of(context.with(B3Propagator.DEBUG_CONTEXT_KEY, (Object)true).with((ImplicitContextKeyed)Span.wrap((SpanContext)Common.buildSpanContext(traceId, spanId, "1"))));
        }
        return Optional.of(context.with((ImplicitContextKeyed)Span.wrap((SpanContext)Common.buildSpanContext(traceId, spanId, sampled))));
    }
}

