/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.extension.trace.propagation;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.extension.trace.propagation.B3Propagator;
import io.opentelemetry.extension.trace.propagation.B3PropagatorExtractor;
import io.opentelemetry.extension.trace.propagation.Common;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import javax.annotation.concurrent.Immutable;

@Immutable
final class B3PropagatorExtractorMultipleHeaders
implements B3PropagatorExtractor {
    private static final Logger logger = Logger.getLogger(B3PropagatorExtractorMultipleHeaders.class.getName());

    B3PropagatorExtractorMultipleHeaders() {
    }

    @Override
    public <C> Optional<Context> extract(Context context, C carrier, TextMapGetter<C> getter) {
        Objects.requireNonNull(carrier, "carrier");
        Objects.requireNonNull(getter, "getter");
        return B3PropagatorExtractorMultipleHeaders.extractSpanContextFromMultipleHeaders(context, carrier, getter);
    }

    private static <C> Optional<Context> extractSpanContextFromMultipleHeaders(Context context, C carrier, TextMapGetter<C> getter) {
        String traceId = getter.get(carrier, "X-B3-TraceId");
        if (!Common.isTraceIdValid(traceId)) {
            logger.fine("Invalid TraceId in B3 header: " + traceId + "'. Returning INVALID span context.");
            return Optional.empty();
        }
        String spanId = getter.get(carrier, "X-B3-SpanId");
        if (!Common.isSpanIdValid(spanId)) {
            logger.fine("Invalid SpanId in B3 header: " + spanId + "'. Returning INVALID span context.");
            return Optional.empty();
        }
        if ("1".equals(getter.get(carrier, "X-B3-Flags"))) {
            return Optional.of(context.with(B3Propagator.DEBUG_CONTEXT_KEY, (Object)true).with((ImplicitContextKeyed)Span.wrap((SpanContext)Common.buildSpanContext(traceId, spanId, "1"))));
        }
        String sampled = getter.get(carrier, "X-B3-Sampled");
        return Optional.of(context.with((ImplicitContextKeyed)Span.wrap((SpanContext)Common.buildSpanContext(traceId, spanId, sampled))));
    }
}

