/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.extension.trace.propagation;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapPropagator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class TraceMultiPropagator
implements TextMapPropagator {
    private final TextMapPropagator[] propagators;
    private final Collection<String> propagatorsFields;

    public static TextMapPropagator create(TextMapPropagator ... propagators) {
        return TraceMultiPropagator.create(Arrays.asList(propagators));
    }

    public static TextMapPropagator create(Iterable<TextMapPropagator> propagators) {
        ArrayList<TextMapPropagator> propagatorsList = new ArrayList<TextMapPropagator>();
        for (TextMapPropagator propagator : propagators) {
            Objects.requireNonNull(propagator, "propagator");
            propagatorsList.add(propagator);
        }
        if (propagatorsList.isEmpty()) {
            return TextMapPropagator.noop();
        }
        if (propagatorsList.size() == 1) {
            return (TextMapPropagator)propagatorsList.get(0);
        }
        return new TraceMultiPropagator(propagatorsList);
    }

    private TraceMultiPropagator(List<TextMapPropagator> propagatorList) {
        this.propagators = new TextMapPropagator[propagatorList.size()];
        propagatorList.toArray(this.propagators);
        LinkedHashSet fields = new LinkedHashSet();
        for (TextMapPropagator propagator : this.propagators) {
            fields.addAll(propagator.fields());
        }
        this.propagatorsFields = Collections.unmodifiableList(new ArrayList(fields));
    }

    @Deprecated
    public static Builder builder() {
        return new Builder();
    }

    public Collection<String> fields() {
        return this.propagatorsFields;
    }

    public <C> void inject(Context context, C carrier, TextMapPropagator.Setter<C> setter) {
        for (int i = this.propagators.length - 1; i >= 0; --i) {
            this.propagators[i].inject(context, carrier, setter);
        }
    }

    public <C> Context extract(Context context, @Nullable C carrier, TextMapPropagator.Getter<C> getter) {
        for (int i = this.propagators.length - 1; i >= 0 && !TraceMultiPropagator.isSpanContextExtracted(context = this.propagators[i].extract(context, carrier, getter)); --i) {
        }
        return context;
    }

    private static boolean isSpanContextExtracted(Context context) {
        return Span.fromContextOrNull((Context)context) != null;
    }

    @Deprecated
    public static class Builder {
        private final List<TextMapPropagator> propagators = new ArrayList<TextMapPropagator>();

        private Builder() {
        }

        @Deprecated
        public Builder addPropagator(TextMapPropagator propagator) {
            Objects.requireNonNull(propagator, "propagator");
            this.propagators.add(propagator);
            return this;
        }

        @Deprecated
        public TraceMultiPropagator build() {
            return new TraceMultiPropagator(this.propagators);
        }
    }
}

