/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.extension.trace.propagation;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.TraceId;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.extension.trace.propagation.Common;
import io.opentelemetry.extension.trace.propagation.StringUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class OtTracerPropagator
implements TextMapPropagator {
    static final String TRACE_ID_HEADER = "ot-tracer-traceid";
    static final String SPAN_ID_HEADER = "ot-tracer-spanid";
    static final String SAMPLED_HEADER = "ot-tracer-sampled";
    private static final Collection<String> FIELDS = Collections.unmodifiableList(Arrays.asList("ot-tracer-traceid", "ot-tracer-spanid", "ot-tracer-sampled"));
    private static final OtTracerPropagator INSTANCE = new OtTracerPropagator();

    private OtTracerPropagator() {
    }

    public static OtTracerPropagator getInstance() {
        return INSTANCE;
    }

    public Collection<String> fields() {
        return FIELDS;
    }

    public <C> void inject(Context context, C carrier, TextMapPropagator.Setter<C> setter) {
        if (context == null || setter == null) {
            return;
        }
        SpanContext spanContext = Span.fromContext((Context)context).getSpanContext();
        if (!spanContext.isValid()) {
            return;
        }
        setter.set(carrier, TRACE_ID_HEADER, spanContext.getTraceIdAsHexString());
        setter.set(carrier, SPAN_ID_HEADER, spanContext.getSpanIdAsHexString());
        setter.set(carrier, SAMPLED_HEADER, String.valueOf(spanContext.isSampled()));
    }

    public <C> Context extract(Context context, @Nullable C carrier, TextMapPropagator.Getter<C> getter) {
        String sampled;
        String spanId;
        if (context == null || getter == null) {
            return context;
        }
        String incomingTraceId = getter.get(carrier, TRACE_ID_HEADER);
        String traceId = incomingTraceId == null ? TraceId.getInvalid() : StringUtils.padLeft(incomingTraceId, Common.MAX_TRACE_ID_LENGTH);
        SpanContext spanContext = OtTracerPropagator.buildSpanContext(traceId, spanId = getter.get(carrier, SPAN_ID_HEADER), sampled = getter.get(carrier, SAMPLED_HEADER));
        if (!spanContext.isValid()) {
            return context;
        }
        return context.with((ImplicitContextKeyed)Span.wrap((SpanContext)spanContext));
    }

    static SpanContext buildSpanContext(String traceId, String spanId, String sampled) {
        if (!Common.isTraceIdValid(traceId) || !Common.isSpanIdValid(spanId)) {
            return SpanContext.getInvalid();
        }
        return Common.buildSpanContext(traceId, spanId, sampled);
    }
}

