/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.extension.trace.propagation;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.extension.trace.propagation.B3PropagatorExtractor;
import io.opentelemetry.extension.trace.propagation.Common;
import io.opentelemetry.extension.trace.propagation.StringUtils;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import javax.annotation.concurrent.Immutable;

@Immutable
final class B3PropagatorExtractorSingleHeader
implements B3PropagatorExtractor {
    private static final Logger logger = Logger.getLogger(B3PropagatorExtractorSingleHeader.class.getName());

    B3PropagatorExtractorSingleHeader() {
    }

    @Override
    public <C> Optional<Context> extract(Context context, C carrier, TextMapPropagator.Getter<C> getter) {
        Objects.requireNonNull(carrier, "carrier");
        Objects.requireNonNull(getter, "getter");
        SpanContext spanContext = B3PropagatorExtractorSingleHeader.getSpanContextFromSingleHeader(carrier, getter);
        if (!spanContext.isValid()) {
            return Optional.empty();
        }
        return Optional.of(context.with((ImplicitContextKeyed)Span.wrap((SpanContext)spanContext)));
    }

    private static <C> SpanContext getSpanContextFromSingleHeader(C carrier, TextMapPropagator.Getter<C> getter) {
        String value = getter.get(carrier, "b3");
        if (StringUtils.isNullOrEmpty(value)) {
            return SpanContext.getInvalid();
        }
        String[] parts = value.split("-");
        if (parts.length < 2 || parts.length > 4) {
            logger.fine("Invalid combined header 'b3. Returning INVALID span context.");
            return SpanContext.getInvalid();
        }
        String traceId = parts[0];
        if (!Common.isTraceIdValid(traceId)) {
            logger.fine("Invalid TraceId in B3 header: b3. Returning INVALID span context.");
            return SpanContext.getInvalid();
        }
        String spanId = parts[1];
        if (!Common.isSpanIdValid(spanId)) {
            logger.fine("Invalid SpanId in B3 header: b3. Returning INVALID span context.");
            return SpanContext.getInvalid();
        }
        String sampled = parts.length >= 3 ? parts[2] : null;
        return Common.buildSpanContext(traceId, spanId, sampled);
    }
}

