/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.extension.trace.propagation;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.extension.trace.propagation.B3PropagatorExtractor;
import io.opentelemetry.extension.trace.propagation.B3PropagatorExtractorMultipleHeaders;
import io.opentelemetry.extension.trace.propagation.B3PropagatorExtractorSingleHeader;
import io.opentelemetry.extension.trace.propagation.B3PropagatorInjector;
import io.opentelemetry.extension.trace.propagation.B3PropagatorInjectorMultipleHeaders;
import io.opentelemetry.extension.trace.propagation.B3PropagatorInjectorSingleHeader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class B3Propagator
implements TextMapPropagator {
    static final String TRACE_ID_HEADER = "X-B3-TraceId";
    static final String SPAN_ID_HEADER = "X-B3-SpanId";
    static final String SAMPLED_HEADER = "X-B3-Sampled";
    static final String COMBINED_HEADER = "b3";
    static final String COMBINED_HEADER_DELIMITER = "-";
    static final char COMBINED_HEADER_DELIMITER_CHAR = '-';
    static final char IS_SAMPLED = '1';
    static final char NOT_SAMPLED = '0';
    private static final List<String> FIELDS = Collections.unmodifiableList(Arrays.asList("X-B3-TraceId", "X-B3-SpanId", "X-B3-Sampled", "b3"));
    private static final B3Propagator INSTANCE = B3Propagator.builder().build();
    private final B3PropagatorExtractor singleHeaderExtractor = new B3PropagatorExtractorSingleHeader();
    private final B3PropagatorExtractor multipleHeadersExtractor = new B3PropagatorExtractorMultipleHeaders();
    private final B3PropagatorInjector b3PropagatorInjector;

    private B3Propagator(B3PropagatorInjector b3PropagatorInjector) {
        this.b3PropagatorInjector = b3PropagatorInjector;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static B3Propagator getInstance() {
        return INSTANCE;
    }

    public List<String> fields() {
        return FIELDS;
    }

    public <C> void inject(Context context, @Nullable C carrier, TextMapPropagator.Setter<C> setter) {
        this.b3PropagatorInjector.inject(context, carrier, setter);
    }

    public <C> Context extract(Context context, @Nullable C carrier, TextMapPropagator.Getter<C> getter) {
        return Stream.of(() -> this.singleHeaderExtractor.extract(context, carrier, getter), () -> this.multipleHeadersExtractor.extract(context, carrier, getter), () -> Optional.of(context)).map(Supplier::get).filter(Optional::isPresent).map(Optional::get).findFirst().get();
    }

    public static class Builder {
        private boolean injectSingleHeader = true;

        private Builder() {
        }

        public Builder injectMultipleHeaders() {
            this.injectSingleHeader = false;
            return this;
        }

        public B3Propagator build() {
            if (this.injectSingleHeader) {
                return new B3Propagator(new B3PropagatorInjectorSingleHeader());
            }
            return new B3Propagator(new B3PropagatorInjectorMultipleHeaders());
        }
    }
}

