/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.extensions.trace.propagation;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.trace.TracingContextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class TraceMultiPropagator
implements TextMapPropagator {
    private final TextMapPropagator[] propagators;
    private final List<String> propagatorsFields;

    private TraceMultiPropagator(List<TextMapPropagator> propagatorList) {
        this.propagators = new TextMapPropagator[propagatorList.size()];
        propagatorList.toArray(this.propagators);
        LinkedHashSet fields = new LinkedHashSet();
        for (TextMapPropagator propagator : this.propagators) {
            fields.addAll(propagator.fields());
        }
        this.propagatorsFields = Collections.unmodifiableList(new ArrayList(fields));
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<String> fields() {
        return this.propagatorsFields;
    }

    public <C> void inject(Context context, C carrier, TextMapPropagator.Setter<C> setter) {
        for (int i = this.propagators.length - 1; i >= 0; --i) {
            this.propagators[i].inject(context, carrier, setter);
        }
    }

    public <C> Context extract(Context context, C carrier, TextMapPropagator.Getter<C> getter) {
        for (int i = this.propagators.length - 1; i >= 0 && !TraceMultiPropagator.isSpanContextExtracted(context = this.propagators[i].extract(context, carrier, getter)); --i) {
        }
        return context;
    }

    private static boolean isSpanContextExtracted(Context context) {
        return TracingContextUtils.getSpanWithoutDefault((Context)context) != null;
    }

    public static class Builder {
        private final List<TextMapPropagator> propagators = new ArrayList<TextMapPropagator>();

        private Builder() {
        }

        public Builder addPropagator(TextMapPropagator propagator) {
            Objects.requireNonNull(propagator, "propagator");
            this.propagators.add(propagator);
            return this;
        }

        public TraceMultiPropagator build() {
            return new TraceMultiPropagator(this.propagators);
        }
    }
}

