/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.extensions.trace.propagation;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.extensions.trace.propagation.StringUtils;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.SpanContext;
import io.opentelemetry.trace.SpanId;
import io.opentelemetry.trace.TraceFlags;
import io.opentelemetry.trace.TraceId;
import io.opentelemetry.trace.TraceState;
import io.opentelemetry.trace.TracingContextUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.Immutable;

@Immutable
public class JaegerPropagator
implements TextMapPropagator {
    private static final Logger logger = Logger.getLogger(JaegerPropagator.class.getName());
    static final String PROPAGATION_HEADER = "uber-trace-id";
    static final char DEPRECATED_PARENT_SPAN = '0';
    static final char PROPAGATION_HEADER_DELIMITER = ':';
    private static final int MAX_TRACE_ID_LENGTH = TraceId.getHexLength();
    private static final int MAX_SPAN_ID_LENGTH = SpanId.getHexLength();
    private static final int MAX_FLAGS_LENGTH = 2;
    private static final char IS_SAMPLED_CHAR = '1';
    private static final char NOT_SAMPLED_CHAR = '0';
    private static final int PROPAGATION_HEADER_DELIMITER_SIZE = 1;
    private static final int TRACE_ID_HEX_SIZE = TraceId.getHexLength();
    private static final int SPAN_ID_HEX_SIZE = SpanId.getHexLength();
    private static final int PARENT_SPAN_ID_SIZE = 1;
    private static final int SAMPLED_FLAG_SIZE = 1;
    private static final int SPAN_ID_OFFSET = TRACE_ID_HEX_SIZE + 1;
    private static final int PARENT_SPAN_ID_OFFSET = SPAN_ID_OFFSET + SPAN_ID_HEX_SIZE + 1;
    private static final int SAMPLED_FLAG_OFFSET = PARENT_SPAN_ID_OFFSET + 1 + 1;
    private static final int PROPAGATION_HEADER_SIZE = SAMPLED_FLAG_OFFSET + 1;
    private static final byte SAMPLED = TraceFlags.getSampled();
    private static final byte NOT_SAMPLED = TraceFlags.getDefault();
    private static final List<String> FIELDS = Collections.singletonList("uber-trace-id");
    private static final JaegerPropagator INSTANCE = new JaegerPropagator();

    private JaegerPropagator() {
    }

    public static JaegerPropagator getInstance() {
        return INSTANCE;
    }

    public List<String> fields() {
        return FIELDS;
    }

    public <C> void inject(Context context, C carrier, TextMapPropagator.Setter<C> setter) {
        Objects.requireNonNull(context, "context");
        Objects.requireNonNull(setter, "setter");
        SpanContext spanContext = TracingContextUtils.getSpan((Context)context).getContext();
        if (!spanContext.isValid()) {
            return;
        }
        char[] chars = new char[PROPAGATION_HEADER_SIZE];
        String traceId = spanContext.getTraceIdAsHexString();
        for (int i = 0; i < traceId.length(); ++i) {
            chars[i] = traceId.charAt(i);
        }
        chars[JaegerPropagator.SPAN_ID_OFFSET - 1] = 58;
        String spanId = spanContext.getSpanIdAsHexString();
        for (int i = 0; i < spanId.length(); ++i) {
            chars[JaegerPropagator.SPAN_ID_OFFSET + i] = spanId.charAt(i);
        }
        chars[JaegerPropagator.PARENT_SPAN_ID_OFFSET - 1] = 58;
        chars[JaegerPropagator.PARENT_SPAN_ID_OFFSET] = 48;
        chars[JaegerPropagator.SAMPLED_FLAG_OFFSET - 1] = 58;
        chars[JaegerPropagator.SAMPLED_FLAG_OFFSET] = spanContext.isSampled() ? 49 : 48;
        setter.set(carrier, PROPAGATION_HEADER, new String(chars));
    }

    public <C> Context extract(Context context, C carrier, TextMapPropagator.Getter<C> getter) {
        Objects.requireNonNull(carrier, "carrier");
        Objects.requireNonNull(getter, "getter");
        SpanContext spanContext = JaegerPropagator.getSpanContextFromHeader(carrier, getter);
        if (!spanContext.isValid()) {
            return context;
        }
        return TracingContextUtils.withSpan((Span)Span.wrap((SpanContext)spanContext), (Context)context);
    }

    private static <C> SpanContext getSpanContextFromHeader(C carrier, TextMapPropagator.Getter<C> getter) {
        String[] parts;
        String value = getter.get(carrier, PROPAGATION_HEADER);
        if (StringUtils.isNullOrEmpty(value)) {
            return SpanContext.getInvalid();
        }
        if (value.lastIndexOf(58) == -1) {
            try {
                value = URLDecoder.decode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                logger.fine("Error decoding 'uber-trace-id' with value " + value + ". Returning INVALID span context.");
                return SpanContext.getInvalid();
            }
        }
        if ((parts = value.split(String.valueOf(':'))).length != 4) {
            logger.fine("Invalid header 'uber-trace-id' with value " + value + ". Returning INVALID span context.");
            return SpanContext.getInvalid();
        }
        String traceId = parts[0];
        if (!JaegerPropagator.isTraceIdValid(traceId)) {
            logger.fine("Invalid TraceId in Jaeger header: 'uber-trace-id' with traceId " + traceId + ". Returning INVALID span context.");
            return SpanContext.getInvalid();
        }
        String spanId = parts[1];
        if (!JaegerPropagator.isSpanIdValid(spanId)) {
            logger.fine("Invalid SpanId in Jaeger header: 'uber-trace-id'. Returning INVALID span context.");
            return SpanContext.getInvalid();
        }
        String flags = parts[3];
        if (!JaegerPropagator.isFlagsValid(flags)) {
            logger.fine("Invalid Flags in Jaeger header: 'uber-trace-id'. Returning INVALID span context.");
            return SpanContext.getInvalid();
        }
        return JaegerPropagator.buildSpanContext(traceId, spanId, flags);
    }

    private static SpanContext buildSpanContext(String traceId, String spanId, String flags) {
        try {
            int flagsInt = Integer.parseInt(flags);
            byte traceFlags = (flagsInt & 1) == 1 ? SAMPLED : NOT_SAMPLED;
            String otelTraceId = StringUtils.padLeft(traceId, MAX_TRACE_ID_LENGTH);
            String otelSpanId = StringUtils.padLeft(spanId, MAX_SPAN_ID_LENGTH);
            if (!TraceId.isValid((CharSequence)otelTraceId) || !SpanId.isValid((String)otelSpanId)) {
                return SpanContext.getInvalid();
            }
            return SpanContext.createFromRemoteParent((String)otelTraceId, (String)otelSpanId, (byte)traceFlags, (TraceState)TraceState.getDefault());
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Error parsing 'uber-trace-id' header. Returning INVALID span context.", e);
            return SpanContext.getInvalid();
        }
    }

    private static boolean isTraceIdValid(String value) {
        return !StringUtils.isNullOrEmpty(value) && value.length() <= MAX_TRACE_ID_LENGTH;
    }

    private static boolean isSpanIdValid(String value) {
        return !StringUtils.isNullOrEmpty(value) && value.length() <= MAX_SPAN_ID_LENGTH;
    }

    private static boolean isFlagsValid(String value) {
        return !StringUtils.isNullOrEmpty(value) && value.length() <= 2;
    }
}

