/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporters.otlp;

import io.opentelemetry.common.AttributeConsumer;
import io.opentelemetry.common.AttributeKey;
import io.opentelemetry.common.Attributes;
import io.opentelemetry.exporters.otlp.CommonAdapter;
import io.opentelemetry.exporters.otlp.ResourceAdapter;
import io.opentelemetry.proto.trace.v1.InstrumentationLibrarySpans;
import io.opentelemetry.proto.trace.v1.ResourceSpans;
import io.opentelemetry.proto.trace.v1.Span;
import io.opentelemetry.proto.trace.v1.Status;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.extensions.otproto.TraceProtoUtils;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.SpanId;
import io.opentelemetry.trace.StatusCanonicalCode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class SpanAdapter {
    static List<ResourceSpans> toProtoResourceSpans(Collection<SpanData> spanDataList) {
        Map<Resource, Map<InstrumentationLibraryInfo, List<Span>>> resourceAndLibraryMap = SpanAdapter.groupByResourceAndLibrary(spanDataList);
        ArrayList<ResourceSpans> resourceSpans = new ArrayList<ResourceSpans>(resourceAndLibraryMap.size());
        for (Map.Entry<Resource, Map<InstrumentationLibraryInfo, List<Span>>> entryResource : resourceAndLibraryMap.entrySet()) {
            ArrayList<InstrumentationLibrarySpans> instrumentationLibrarySpans = new ArrayList<InstrumentationLibrarySpans>(entryResource.getValue().size());
            for (Map.Entry<InstrumentationLibraryInfo, List<Span>> entryLibrary : entryResource.getValue().entrySet()) {
                instrumentationLibrarySpans.add(InstrumentationLibrarySpans.newBuilder().setInstrumentationLibrary(CommonAdapter.toProtoInstrumentationLibrary(entryLibrary.getKey())).addAllSpans((Iterable)entryLibrary.getValue()).build());
            }
            resourceSpans.add(ResourceSpans.newBuilder().setResource(ResourceAdapter.toProtoResource(entryResource.getKey())).addAllInstrumentationLibrarySpans(instrumentationLibrarySpans).build());
        }
        return resourceSpans;
    }

    private static Map<Resource, Map<InstrumentationLibraryInfo, List<Span>>> groupByResourceAndLibrary(Collection<SpanData> spanDataList) {
        HashMap<Resource, Map<InstrumentationLibraryInfo, List<Span>>> result = new HashMap<Resource, Map<InstrumentationLibraryInfo, List<Span>>>();
        for (SpanData spanData : spanDataList) {
            ArrayList<Span> spanList;
            Resource resource = spanData.getResource();
            HashMap<InstrumentationLibraryInfo, ArrayList<Span>> libraryInfoListMap = (HashMap<InstrumentationLibraryInfo, ArrayList<Span>>)result.get(spanData.getResource());
            if (libraryInfoListMap == null) {
                libraryInfoListMap = new HashMap<InstrumentationLibraryInfo, ArrayList<Span>>();
                result.put(resource, libraryInfoListMap);
            }
            if ((spanList = (ArrayList<Span>)libraryInfoListMap.get(spanData.getInstrumentationLibraryInfo())) == null) {
                spanList = new ArrayList<Span>();
                libraryInfoListMap.put(spanData.getInstrumentationLibraryInfo(), spanList);
            }
            spanList.add(SpanAdapter.toProtoSpan(spanData));
        }
        return result;
    }

    static Span toProtoSpan(SpanData spanData) {
        final Span.Builder builder = Span.newBuilder();
        builder.setTraceId(TraceProtoUtils.toProtoTraceId((String)spanData.getTraceId()));
        builder.setSpanId(TraceProtoUtils.toProtoSpanId((String)spanData.getSpanId()));
        if (SpanId.isValid((String)spanData.getParentSpanId())) {
            builder.setParentSpanId(TraceProtoUtils.toProtoSpanId((String)spanData.getParentSpanId()));
        }
        builder.setName(spanData.getName());
        builder.setKind(SpanAdapter.toProtoSpanKind(spanData.getKind()));
        builder.setStartTimeUnixNano(spanData.getStartEpochNanos());
        builder.setEndTimeUnixNano(spanData.getEndEpochNanos());
        spanData.getAttributes().forEach(new AttributeConsumer(){

            public <T> void consume(AttributeKey<T> key, T value) {
                builder.addAttributes(CommonAdapter.toProtoAttribute(key, value));
            }
        });
        builder.setDroppedAttributesCount(spanData.getTotalAttributeCount() - spanData.getAttributes().size());
        for (SpanData.Event event : spanData.getEvents()) {
            builder.addEvents(SpanAdapter.toProtoSpanEvent(event));
        }
        builder.setDroppedEventsCount(spanData.getTotalRecordedEvents() - spanData.getEvents().size());
        for (SpanData.Link link : spanData.getLinks()) {
            builder.addLinks(SpanAdapter.toProtoSpanLink(link));
        }
        builder.setDroppedLinksCount(spanData.getTotalRecordedLinks() - spanData.getLinks().size());
        builder.setStatus(SpanAdapter.toStatusProto(spanData.getStatus()));
        return builder.build();
    }

    static Span.SpanKind toProtoSpanKind(Span.Kind kind) {
        switch (kind) {
            case INTERNAL: {
                return Span.SpanKind.SPAN_KIND_INTERNAL;
            }
            case SERVER: {
                return Span.SpanKind.SPAN_KIND_SERVER;
            }
            case CLIENT: {
                return Span.SpanKind.SPAN_KIND_CLIENT;
            }
            case PRODUCER: {
                return Span.SpanKind.SPAN_KIND_PRODUCER;
            }
            case CONSUMER: {
                return Span.SpanKind.SPAN_KIND_CONSUMER;
            }
        }
        return Span.SpanKind.UNRECOGNIZED;
    }

    static Span.Event toProtoSpanEvent(SpanData.Event event) {
        final Span.Event.Builder builder = Span.Event.newBuilder();
        builder.setName(event.getName());
        builder.setTimeUnixNano(event.getEpochNanos());
        event.getAttributes().forEach(new AttributeConsumer(){

            public <T> void consume(AttributeKey<T> key, T value) {
                builder.addAttributes(CommonAdapter.toProtoAttribute(key, value));
            }
        });
        builder.setDroppedAttributesCount(event.getTotalAttributeCount() - event.getAttributes().size());
        return builder.build();
    }

    static Span.Link toProtoSpanLink(SpanData.Link link) {
        final Span.Link.Builder builder = Span.Link.newBuilder();
        builder.setTraceId(TraceProtoUtils.toProtoTraceId((String)link.getContext().getTraceIdAsHexString()));
        builder.setSpanId(TraceProtoUtils.toProtoSpanId((String)link.getContext().getSpanIdAsHexString()));
        Attributes attributes = link.getAttributes();
        attributes.forEach(new AttributeConsumer(){

            public <T> void consume(AttributeKey<T> key, T value) {
                builder.addAttributes(CommonAdapter.toProtoAttribute(key, value));
            }
        });
        builder.setDroppedAttributesCount(link.getTotalAttributeCount() - attributes.size());
        return builder.build();
    }

    static Status toStatusProto(SpanData.Status status) {
        Status.StatusCode protoStatusCode = Status.StatusCode.STATUS_CODE_OK;
        if (status.getCanonicalCode() == StatusCanonicalCode.ERROR) {
            protoStatusCode = Status.StatusCode.STATUS_CODE_UNKNOWN_ERROR;
        }
        Status.Builder builder = Status.newBuilder().setCode(protoStatusCode);
        if (status.getDescription() != null) {
            builder.setMessage(status.getDescription());
        }
        return builder.build();
    }

    private SpanAdapter() {
    }
}

