/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.zipkin;

import io.opentelemetry.exporter.zipkin.ZipkinSpanExporter;
import zipkin2.Span;
import zipkin2.codec.BytesEncoder;
import zipkin2.codec.SpanBytesEncoder;
import zipkin2.reporter.Sender;
import zipkin2.reporter.okhttp3.OkHttpSender;

public final class ZipkinSpanExporterBuilder {
    private BytesEncoder<Span> encoder = SpanBytesEncoder.JSON_V2;
    private Sender sender;
    private String endpoint = "http://localhost:9411/api/v2/spans";

    public ZipkinSpanExporterBuilder setSender(Sender sender) {
        this.sender = sender;
        return this;
    }

    public ZipkinSpanExporterBuilder setEncoder(BytesEncoder<Span> encoder) {
        this.encoder = encoder;
        return this;
    }

    public ZipkinSpanExporterBuilder setEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public ZipkinSpanExporter build() {
        if (this.sender == null) {
            this.sender = OkHttpSender.create((String)this.endpoint);
        }
        return new ZipkinSpanExporter(this.encoder, this.sender);
    }
}

