/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.zipkin;

import io.opentelemetry.exporter.zipkin.ZipkinSpanExporter;
import io.opentelemetry.sdk.common.export.ConfigBuilder;
import java.util.Map;
import zipkin2.Span;
import zipkin2.codec.BytesEncoder;
import zipkin2.codec.SpanBytesEncoder;
import zipkin2.reporter.Sender;
import zipkin2.reporter.okhttp3.OkHttpSender;

public final class ZipkinSpanExporterBuilder
extends ConfigBuilder<ZipkinSpanExporterBuilder> {
    private static final String KEY_SERVICE_NAME = "otel.exporter.zipkin.service.name";
    private static final String KEY_ENDPOINT = "otel.exporter.zipkin.endpoint";
    private BytesEncoder<Span> encoder = SpanBytesEncoder.JSON_V2;
    private Sender sender;
    private String serviceName = "unknown";
    private String endpoint = "http://localhost:9411/api/v2/spans";

    public ZipkinSpanExporterBuilder setServiceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    public ZipkinSpanExporterBuilder setSender(Sender sender) {
        this.sender = sender;
        return this;
    }

    public ZipkinSpanExporterBuilder setEncoder(BytesEncoder<Span> encoder) {
        this.encoder = encoder;
        return this;
    }

    public ZipkinSpanExporterBuilder setEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    protected ZipkinSpanExporterBuilder fromConfigMap(Map<String, String> configMap, ConfigBuilder.NamingConvention namingConvention) {
        String stringValue = ZipkinSpanExporterBuilder.getStringProperty((String)KEY_SERVICE_NAME, (Map)(configMap = namingConvention.normalize(configMap)));
        if (stringValue != null) {
            this.setServiceName(stringValue);
        }
        if ((stringValue = ZipkinSpanExporterBuilder.getStringProperty((String)KEY_ENDPOINT, (Map)configMap)) != null) {
            this.setEndpoint(stringValue);
        }
        return this;
    }

    public ZipkinSpanExporter build() {
        if (this.sender == null) {
            this.sender = OkHttpSender.create((String)this.endpoint);
        }
        return new ZipkinSpanExporter(this.encoder, this.sender, this.serviceName);
    }
}

