/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.zipkin;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributeType;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.exporter.zipkin.ZipkinSpanExporterBuilder;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.resources.ResourceAttributes;
import io.opentelemetry.sdk.trace.data.EventData;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.data.StatusData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import zipkin2.Callback;
import zipkin2.Endpoint;
import zipkin2.Span;
import zipkin2.codec.BytesEncoder;
import zipkin2.reporter.Sender;

public final class ZipkinSpanExporter
implements SpanExporter {
    public static final String DEFAULT_ENDPOINT = "http://localhost:9411/api/v2/spans";
    public static final String DEFAULT_SERVICE_NAME = "unknown";
    private static final Logger logger = Logger.getLogger(ZipkinSpanExporter.class.getName());
    static final String OTEL_STATUS_CODE = "otel.status_code";
    static final String OTEL_STATUS_DESCRIPTION = "otel.status_description";
    static final AttributeKey<String> STATUS_ERROR = AttributeKey.stringKey((String)"error");
    static final String KEY_INSTRUMENTATION_LIBRARY_NAME = "otel.library.name";
    static final String KEY_INSTRUMENTATION_LIBRARY_VERSION = "otel.library.version";
    private final BytesEncoder<Span> encoder;
    private final Sender sender;
    private final Endpoint localEndpoint;

    ZipkinSpanExporter(BytesEncoder<Span> encoder, Sender sender, String serviceName) {
        this.encoder = encoder;
        this.sender = sender;
        this.localEndpoint = ZipkinSpanExporter.produceLocalEndpoint(serviceName);
    }

    static Endpoint produceLocalEndpoint(String serviceName) {
        Endpoint.Builder builder;
        block4: {
            builder = Endpoint.newBuilder().serviceName(serviceName);
            try {
                Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
                block2: while (nics.hasMoreElements()) {
                    NetworkInterface nic = nics.nextElement();
                    Enumeration<InetAddress> addresses = nic.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        InetAddress address = addresses.nextElement();
                        if (!address.isSiteLocalAddress()) continue;
                        builder.ip(address);
                        continue block2;
                    }
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.FINE)) break block4;
                logger.log(Level.FINE, "error reading nics", e);
            }
        }
        return builder.build();
    }

    static Span generateSpan(SpanData spanData, Endpoint localEndpoint) {
        InstrumentationLibraryInfo instrumentationLibraryInfo;
        Endpoint endpoint = ZipkinSpanExporter.chooseEndpoint(spanData, localEndpoint);
        long startTimestamp = ZipkinSpanExporter.toEpochMicros(spanData.getStartEpochNanos());
        long endTimestamp = ZipkinSpanExporter.toEpochMicros(spanData.getEndEpochNanos());
        Span.Builder spanBuilder = Span.newBuilder().traceId(spanData.getTraceId()).id(spanData.getSpanId()).kind(ZipkinSpanExporter.toSpanKind(spanData)).name(spanData.getName()).timestamp(ZipkinSpanExporter.toEpochMicros(spanData.getStartEpochNanos())).duration(Math.max(1L, endTimestamp - startTimestamp)).localEndpoint(endpoint);
        if (spanData.getParentSpanContext().isValid()) {
            spanBuilder.parentId(spanData.getParentSpanId());
        }
        Attributes spanAttributes = spanData.getAttributes();
        spanAttributes.forEach((key, value) -> spanBuilder.putTag(key.getKey(), ZipkinSpanExporter.valueToString(key, value)));
        StatusData status = spanData.getStatus();
        if (status.getStatusCode() != StatusCode.UNSET) {
            spanBuilder.putTag(OTEL_STATUS_CODE, status.getStatusCode().toString());
            if (status.getStatusCode() == StatusCode.ERROR && spanAttributes.get(STATUS_ERROR) == null) {
                spanBuilder.putTag(STATUS_ERROR.getKey(), ZipkinSpanExporter.nullToEmpty(status.getDescription()));
            }
        }
        if (!(instrumentationLibraryInfo = spanData.getInstrumentationLibraryInfo()).getName().isEmpty()) {
            spanBuilder.putTag(KEY_INSTRUMENTATION_LIBRARY_NAME, instrumentationLibraryInfo.getName());
        }
        if (instrumentationLibraryInfo.getVersion() != null) {
            spanBuilder.putTag(KEY_INSTRUMENTATION_LIBRARY_VERSION, instrumentationLibraryInfo.getVersion());
        }
        for (EventData annotation : spanData.getEvents()) {
            spanBuilder.addAnnotation(ZipkinSpanExporter.toEpochMicros(annotation.getEpochNanos()), annotation.getName());
        }
        return spanBuilder.build();
    }

    private static String nullToEmpty(String value) {
        return value != null ? value : "";
    }

    private static Endpoint chooseEndpoint(SpanData spanData, Endpoint localEndpoint) {
        Attributes resourceAttributes = spanData.getResource().getAttributes();
        String serviceNameValue = (String)resourceAttributes.get(ResourceAttributes.SERVICE_NAME);
        if (serviceNameValue == null) {
            return localEndpoint;
        }
        return Endpoint.newBuilder().serviceName(serviceNameValue).build();
    }

    @Nullable
    private static Span.Kind toSpanKind(SpanData spanData) {
        if (spanData.getKind() == Span.Kind.SERVER) {
            return Span.Kind.SERVER;
        }
        if (spanData.getKind() == Span.Kind.CLIENT || spanData.getName().startsWith("Sent.")) {
            return Span.Kind.CLIENT;
        }
        if (spanData.getKind() == Span.Kind.PRODUCER) {
            return Span.Kind.PRODUCER;
        }
        if (spanData.getKind() == Span.Kind.CONSUMER) {
            return Span.Kind.CONSUMER;
        }
        return null;
    }

    private static long toEpochMicros(long epochNanos) {
        return TimeUnit.NANOSECONDS.toMicros(epochNanos);
    }

    private static <T> String valueToString(AttributeKey<?> key, Object attributeValue) {
        AttributeType type = key.getType();
        switch (type) {
            case STRING: 
            case BOOLEAN: 
            case LONG: 
            case DOUBLE: {
                return String.valueOf(attributeValue);
            }
            case STRING_ARRAY: 
            case BOOLEAN_ARRAY: 
            case LONG_ARRAY: 
            case DOUBLE_ARRAY: {
                return ZipkinSpanExporter.commaSeparated((List)attributeValue);
            }
        }
        throw new IllegalStateException("Unknown attribute type: " + type);
    }

    private static String commaSeparated(List<?> values) {
        StringBuilder builder = new StringBuilder();
        for (Object value : values) {
            if (builder.length() != 0) {
                builder.append(',');
            }
            builder.append(value);
        }
        return builder.toString();
    }

    public CompletableResultCode export(Collection<SpanData> spanDataList) {
        ArrayList<byte[]> encodedSpans = new ArrayList<byte[]>(spanDataList.size());
        for (SpanData spanData : spanDataList) {
            encodedSpans.add(this.encoder.encode((Object)ZipkinSpanExporter.generateSpan(spanData, this.localEndpoint)));
        }
        final CompletableResultCode result = new CompletableResultCode();
        this.sender.sendSpans(encodedSpans).enqueue((Callback)new Callback<Void>(){

            public void onSuccess(Void value) {
                result.succeed();
            }

            public void onError(Throwable t) {
                logger.log(Level.WARNING, "Failed to export spans", t);
                result.fail();
            }
        });
        return result;
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode shutdown() {
        try {
            this.sender.close();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Exception while closing the Zipkin Sender instance", e);
        }
        return CompletableResultCode.ofSuccess();
    }

    public static ZipkinSpanExporterBuilder builder() {
        return new ZipkinSpanExporterBuilder();
    }
}

