/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.sender.okhttp.internal;

import io.opentelemetry.api.internal.InstrumentationUtil;
import io.opentelemetry.exporter.internal.RetryUtil;
import io.opentelemetry.exporter.internal.compression.Compressor;
import io.opentelemetry.exporter.internal.grpc.GrpcResponse;
import io.opentelemetry.exporter.internal.grpc.GrpcSender;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.sender.okhttp.internal.GrpcRequestBody;
import io.opentelemetry.exporter.sender.okhttp.internal.OkHttpUtil;
import io.opentelemetry.exporter.sender.okhttp.internal.RetryInterceptor;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.common.export.RetryPolicy;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.ConnectionSpec;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public final class OkHttpGrpcSender<T extends Marshaler>
implements GrpcSender<T> {
    private static final String GRPC_STATUS = "grpc-status";
    private static final String GRPC_MESSAGE = "grpc-message";
    private final OkHttpClient client;
    private final HttpUrl url;
    private final Supplier<Map<String, List<String>>> headersSupplier;
    @Nullable
    private final Compressor compressor;

    public OkHttpGrpcSender(String endpoint, @Nullable Compressor compressor, long timeoutNanos, long connectTimeoutNanos, Supplier<Map<String, List<String>>> headersSupplier, @Nullable RetryPolicy retryPolicy, @Nullable SSLContext sslContext, @Nullable X509TrustManager trustManager) {
        boolean isPlainHttp;
        int callTimeoutMillis = (int)Math.min(Duration.ofNanos(timeoutNanos).toMillis(), Integer.MAX_VALUE);
        int connectTimeoutMillis = (int)Math.min(Duration.ofNanos(connectTimeoutNanos).toMillis(), Integer.MAX_VALUE);
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().dispatcher(OkHttpUtil.newDispatcher()).callTimeout(Duration.ofMillis(callTimeoutMillis)).connectTimeout(Duration.ofMillis(connectTimeoutMillis));
        if (retryPolicy != null) {
            clientBuilder.addInterceptor((Interceptor)new RetryInterceptor(retryPolicy, OkHttpGrpcSender::isRetryable));
        }
        if (isPlainHttp = endpoint.startsWith("http://")) {
            clientBuilder.connectionSpecs(Collections.singletonList(ConnectionSpec.CLEARTEXT));
            clientBuilder.protocols(Collections.singletonList(Protocol.H2_PRIOR_KNOWLEDGE));
        } else {
            clientBuilder.protocols(Arrays.asList(Protocol.HTTP_2, Protocol.HTTP_1_1));
            if (sslContext != null && trustManager != null) {
                clientBuilder.sslSocketFactory(sslContext.getSocketFactory(), trustManager);
            }
        }
        this.client = clientBuilder.build();
        this.headersSupplier = headersSupplier;
        this.url = HttpUrl.get((String)endpoint);
        this.compressor = compressor;
    }

    public void send(T request, final Consumer<GrpcResponse> onResponse, final Consumer<Throwable> onError) {
        Request.Builder requestBuilder = new Request.Builder().url(this.url);
        Map<String, List<String>> headers = this.headersSupplier.get();
        if (headers != null) {
            headers.forEach((key, values) -> values.forEach(value -> requestBuilder.addHeader(key, value)));
        }
        requestBuilder.addHeader("te", "trailers");
        if (this.compressor != null) {
            requestBuilder.addHeader("grpc-encoding", this.compressor.getEncoding());
        }
        GrpcRequestBody requestBody = new GrpcRequestBody((Marshaler)request, this.compressor);
        requestBuilder.post((RequestBody)requestBody);
        InstrumentationUtil.suppressInstrumentation(() -> this.client.newCall(requestBuilder.build()).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                onError.accept(e);
            }

            public void onResponse(Call call, Response response) {
                int statusCode;
                try {
                    response.body().bytes();
                }
                catch (IOException e) {
                    onError.accept(new RuntimeException("Could not consume server response", e));
                    return;
                }
                String status = OkHttpGrpcSender.grpcStatus(response);
                String description = OkHttpGrpcSender.grpcMessage(response);
                try {
                    statusCode = Integer.parseInt(status);
                }
                catch (NumberFormatException ex) {
                    statusCode = 2;
                }
                onResponse.accept(GrpcResponse.create((int)statusCode, (String)description));
            }
        }));
    }

    @Nullable
    private static String grpcStatus(Response response) {
        String grpcStatus = response.header(GRPC_STATUS);
        if (grpcStatus == null) {
            try {
                grpcStatus = response.trailers().get(GRPC_STATUS);
            }
            catch (IOException e) {
                return null;
            }
        }
        return grpcStatus;
    }

    private static String grpcMessage(Response response) {
        String message = response.header(GRPC_MESSAGE);
        if (message == null) {
            try {
                message = response.trailers().get(GRPC_MESSAGE);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (message != null) {
            return OkHttpGrpcSender.unescape(message);
        }
        return response.message();
    }

    public CompletableResultCode shutdown() {
        this.client.dispatcher().cancelAll();
        this.client.dispatcher().executorService().shutdownNow();
        this.client.connectionPool().evictAll();
        return CompletableResultCode.ofSuccess();
    }

    public static boolean isRetryable(Response response) {
        String grpcStatus = response.header(GRPC_STATUS);
        if (grpcStatus == null) {
            return false;
        }
        return RetryUtil.retryableGrpcStatusCodes().contains(grpcStatus);
    }

    private static String unescape(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c >= ' ' && c < '~' && (c != '%' || i + 2 >= value.length())) continue;
            return OkHttpGrpcSender.doUnescape(value.getBytes(StandardCharsets.US_ASCII));
        }
        return value;
    }

    private static String doUnescape(byte[] value) {
        ByteBuffer buf = ByteBuffer.allocate(value.length);
        int i = 0;
        while (i < value.length) {
            if (value[i] == 37 && i + 2 < value.length) {
                try {
                    buf.put((byte)Integer.parseInt(new String(value, i + 1, 2, StandardCharsets.UTF_8), 16));
                    i += 3;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            buf.put(value[i]);
            ++i;
        }
        return new String(buf.array(), 0, buf.position(), StandardCharsets.UTF_8);
    }
}

