/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.prometheus;

import io.opentelemetry.exporter.prometheus.Otel2PrometheusConverter;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.export.CollectionRegistration;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.prometheus.metrics.model.registry.MultiCollector;
import io.prometheus.metrics.model.snapshots.MetricSnapshots;

public class PrometheusMetricReader
implements MetricReader,
MultiCollector {
    private volatile CollectionRegistration collectionRegistration = CollectionRegistration.noop();
    private final Otel2PrometheusConverter converter;

    public PrometheusMetricReader(boolean otelScopeEnabled) {
        this.converter = new Otel2PrometheusConverter(otelScopeEnabled);
    }

    public AggregationTemporality getAggregationTemporality(InstrumentType instrumentType) {
        return AggregationTemporality.CUMULATIVE;
    }

    public void register(CollectionRegistration registration) {
        this.collectionRegistration = registration;
    }

    public CompletableResultCode forceFlush() {
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode shutdown() {
        return CompletableResultCode.ofSuccess();
    }

    public MetricSnapshots collect() {
        return this.converter.convert(this.collectionRegistration.collectAllMetrics());
    }
}

