/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.prometheus;

import io.opentelemetry.exporter.prometheus.MetricAdapter;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.MetricProducer;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.opentelemetry.sdk.metrics.export.MetricReaderFactory;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class PrometheusCollector
extends Collector
implements MetricReader {
    private final MetricProducer metricProducer;

    PrometheusCollector(MetricProducer metricProducer) {
        this.metricProducer = metricProducer;
    }

    public List<Collector.MetricFamilySamples> collect() {
        Collection allMetrics = this.metricProducer.collectAllMetrics();
        ArrayList<Collector.MetricFamilySamples> allSamples = new ArrayList<Collector.MetricFamilySamples>(allMetrics.size());
        for (MetricData metricData : allMetrics) {
            allSamples.add(MetricAdapter.toMetricFamilySamples(metricData));
        }
        return Collections.unmodifiableList(allSamples);
    }

    public static MetricReaderFactory create() {
        return new Factory();
    }

    public AggregationTemporality getPreferredTemporality() {
        return AggregationTemporality.CUMULATIVE;
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode shutdown() {
        CollectorRegistry.defaultRegistry.unregister((Collector)this);
        return CompletableResultCode.ofSuccess();
    }

    private static class Factory
    implements MetricReaderFactory {
        private Factory() {
        }

        public MetricReader apply(MetricProducer producer) {
            PrometheusCollector collector = new PrometheusCollector(producer);
            collector.register();
            return collector;
        }
    }
}

