/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.prometheus;

import io.opentelemetry.api.metrics.common.Labels;
import io.opentelemetry.exporter.prometheus.LabelNameSanitizer;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.DoublePointData;
import io.opentelemetry.sdk.metrics.data.DoubleSumData;
import io.opentelemetry.sdk.metrics.data.DoubleSummaryPointData;
import io.opentelemetry.sdk.metrics.data.LongPointData;
import io.opentelemetry.sdk.metrics.data.LongSumData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.data.MetricDataType;
import io.opentelemetry.sdk.metrics.data.PointData;
import io.opentelemetry.sdk.metrics.data.ValueAtPercentile;
import io.prometheus.client.Collector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;

final class MetricAdapter {
    static final String SAMPLE_SUFFIX_COUNT = "_count";
    static final String SAMPLE_SUFFIX_SUM = "_sum";
    static final String LABEL_NAME_QUANTILE = "quantile";
    private static final Function<String, String> sanitizer = new LabelNameSanitizer();

    static Collector.MetricFamilySamples toMetricFamilySamples(MetricData metricData) {
        String cleanMetricName = MetricAdapter.cleanMetricName(metricData.getName());
        Collector.Type type = MetricAdapter.toMetricFamilyType(metricData);
        return new Collector.MetricFamilySamples(cleanMetricName, type, metricData.getDescription(), MetricAdapter.toSamples(cleanMetricName, metricData.getType(), MetricAdapter.getPoints(metricData)));
    }

    private static String cleanMetricName(String descriptorMetricName) {
        return Collector.sanitizeMetricName((String)descriptorMetricName);
    }

    static Collector.Type toMetricFamilyType(MetricData metricData) {
        switch (metricData.getType()) {
            case LONG_GAUGE: 
            case DOUBLE_GAUGE: {
                return Collector.Type.GAUGE;
            }
            case LONG_SUM: {
                LongSumData longSumData = metricData.getLongSumData();
                if (longSumData.isMonotonic() && longSumData.getAggregationTemporality() == AggregationTemporality.CUMULATIVE) {
                    return Collector.Type.COUNTER;
                }
                return Collector.Type.GAUGE;
            }
            case DOUBLE_SUM: {
                DoubleSumData doubleSumData = metricData.getDoubleSumData();
                if (doubleSumData.isMonotonic() && doubleSumData.getAggregationTemporality() == AggregationTemporality.CUMULATIVE) {
                    return Collector.Type.COUNTER;
                }
                return Collector.Type.GAUGE;
            }
            case SUMMARY: {
                return Collector.Type.SUMMARY;
            }
        }
        return Collector.Type.UNKNOWN;
    }

    static List<Collector.MetricFamilySamples.Sample> toSamples(String name, MetricDataType type, Collection<? extends PointData> points) {
        ArrayList<Collector.MetricFamilySamples.Sample> samples = new ArrayList<Collector.MetricFamilySamples.Sample>(MetricAdapter.estimateNumSamples(points.size(), type));
        for (PointData pointData : points) {
            List<String> labelNames = Collections.emptyList();
            List<String> labelValues = Collections.emptyList();
            Labels labels = pointData.getLabels();
            if (labels.size() != 0) {
                labelNames = new ArrayList(labels.size());
                labelValues = new ArrayList(labels.size());
                labels.forEach((BiConsumer)new Consumer(labelNames, labelValues));
            }
            switch (type) {
                case DOUBLE_GAUGE: 
                case DOUBLE_SUM: {
                    DoublePointData doublePoint = (DoublePointData)pointData;
                    samples.add(new Collector.MetricFamilySamples.Sample(name, labelNames, labelValues, doublePoint.getValue()));
                    break;
                }
                case LONG_GAUGE: 
                case LONG_SUM: {
                    LongPointData longPoint = (LongPointData)pointData;
                    samples.add(new Collector.MetricFamilySamples.Sample(name, labelNames, labelValues, (double)longPoint.getValue()));
                    break;
                }
                case SUMMARY: {
                    MetricAdapter.addSummarySamples((DoubleSummaryPointData)pointData, name, labelNames, labelValues, samples);
                }
            }
        }
        return samples;
    }

    private static void addSummarySamples(DoubleSummaryPointData doubleSummaryPoint, String name, List<String> labelNames, List<String> labelValues, List<Collector.MetricFamilySamples.Sample> samples) {
        samples.add(new Collector.MetricFamilySamples.Sample(name + SAMPLE_SUFFIX_COUNT, labelNames, labelValues, (double)doubleSummaryPoint.getCount()));
        samples.add(new Collector.MetricFamilySamples.Sample(name + SAMPLE_SUFFIX_SUM, labelNames, labelValues, doubleSummaryPoint.getSum()));
        List valueAtPercentiles = doubleSummaryPoint.getPercentileValues();
        ArrayList<String> labelNamesWithQuantile = new ArrayList<String>(labelNames.size());
        labelNamesWithQuantile.addAll(labelNames);
        labelNamesWithQuantile.add(LABEL_NAME_QUANTILE);
        for (ValueAtPercentile valueAtPercentile : valueAtPercentiles) {
            ArrayList<String> labelValuesWithQuantile = new ArrayList<String>(labelValues.size());
            labelValuesWithQuantile.addAll(labelValues);
            labelValuesWithQuantile.add(Collector.doubleToGoString((double)valueAtPercentile.getPercentile()));
            samples.add(new Collector.MetricFamilySamples.Sample(name, labelNamesWithQuantile, labelValuesWithQuantile, valueAtPercentile.getValue()));
        }
    }

    private static int estimateNumSamples(int numPoints, MetricDataType type) {
        if (type == MetricDataType.SUMMARY) {
            return numPoints * 4;
        }
        return numPoints;
    }

    private static Collection<? extends PointData> getPoints(MetricData metricData) {
        switch (metricData.getType()) {
            case DOUBLE_GAUGE: {
                return metricData.getDoubleGaugeData().getPoints();
            }
            case DOUBLE_SUM: {
                return metricData.getDoubleSumData().getPoints();
            }
            case LONG_GAUGE: {
                return metricData.getLongGaugeData().getPoints();
            }
            case LONG_SUM: {
                return metricData.getLongSumData().getPoints();
            }
            case SUMMARY: {
                return metricData.getDoubleSummaryData().getPoints();
            }
        }
        return Collections.emptyList();
    }

    private MetricAdapter() {
    }

    private static final class Consumer
    implements BiConsumer<String, String> {
        final List<String> labelNames;
        final List<String> labelValues;

        private Consumer(List<String> labelNames, List<String> labelValues) {
            this.labelNames = labelNames;
            this.labelValues = labelValues;
        }

        @Override
        public void accept(String labelName, String value) {
            String sanitizedLabelName = (String)sanitizer.apply(labelName);
            this.labelNames.add(sanitizedLabelName);
            this.labelValues.add(value == null ? "" : value);
        }
    }
}

