/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.prometheus;

import io.opentelemetry.api.common.Labels;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.prometheus.client.Collector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;

final class MetricAdapter {
    static final String SAMPLE_SUFFIX_COUNT = "_count";
    static final String SAMPLE_SUFFIX_SUM = "_sum";
    static final String LABEL_NAME_QUANTILE = "quantile";

    static Collector.MetricFamilySamples toMetricFamilySamples(MetricData metricData) {
        String cleanMetricName = MetricAdapter.cleanMetricName(metricData.getName());
        Collector.Type type = MetricAdapter.toMetricFamilyType(metricData.getType());
        return new Collector.MetricFamilySamples(cleanMetricName, type, metricData.getDescription(), MetricAdapter.toSamples(cleanMetricName, metricData.getType(), metricData.getPoints()));
    }

    private static String cleanMetricName(String descriptorMetricName) {
        return Collector.sanitizeMetricName((String)descriptorMetricName);
    }

    static Collector.Type toMetricFamilyType(MetricData.Type type) {
        switch (type) {
            case NON_MONOTONIC_LONG: 
            case NON_MONOTONIC_DOUBLE: 
            case GAUGE_LONG: 
            case GAUGE_DOUBLE: {
                return Collector.Type.GAUGE;
            }
            case MONOTONIC_LONG: 
            case MONOTONIC_DOUBLE: {
                return Collector.Type.COUNTER;
            }
            case SUMMARY: {
                return Collector.Type.SUMMARY;
            }
        }
        return Collector.Type.UNTYPED;
    }

    static List<Collector.MetricFamilySamples.Sample> toSamples(String name, MetricData.Type type, Collection<MetricData.Point> points) {
        ArrayList<Collector.MetricFamilySamples.Sample> samples = new ArrayList<Collector.MetricFamilySamples.Sample>(MetricAdapter.estimateNumSamples(points.size(), type));
        for (MetricData.Point point : points) {
            List<String> labelNames = Collections.emptyList();
            List<String> labelValues = Collections.emptyList();
            Labels labels = point.getLabels();
            if (labels.size() != 0) {
                labelNames = new ArrayList(labels.size());
                labelValues = new ArrayList(labels.size());
                labels.forEach((BiConsumer)new Consumer(labelNames, labelValues));
            }
            switch (type) {
                case NON_MONOTONIC_DOUBLE: 
                case GAUGE_DOUBLE: 
                case MONOTONIC_DOUBLE: {
                    MetricData.DoublePoint doublePoint = (MetricData.DoublePoint)point;
                    samples.add(new Collector.MetricFamilySamples.Sample(name, labelNames, labelValues, doublePoint.getValue()));
                    break;
                }
                case NON_MONOTONIC_LONG: 
                case GAUGE_LONG: 
                case MONOTONIC_LONG: {
                    MetricData.LongPoint longPoint = (MetricData.LongPoint)point;
                    samples.add(new Collector.MetricFamilySamples.Sample(name, labelNames, labelValues, (double)longPoint.getValue()));
                    break;
                }
                case SUMMARY: {
                    MetricAdapter.addSummarySamples((MetricData.SummaryPoint)point, name, labelNames, labelValues, samples);
                }
            }
        }
        return samples;
    }

    static String toLabelName(String labelKey) {
        return Collector.sanitizeMetricName((String)labelKey);
    }

    private static void addSummarySamples(MetricData.SummaryPoint summaryPoint, String name, List<String> labelNames, List<String> labelValues, List<Collector.MetricFamilySamples.Sample> samples) {
        samples.add(new Collector.MetricFamilySamples.Sample(name + SAMPLE_SUFFIX_COUNT, labelNames, labelValues, (double)summaryPoint.getCount()));
        samples.add(new Collector.MetricFamilySamples.Sample(name + SAMPLE_SUFFIX_SUM, labelNames, labelValues, summaryPoint.getSum()));
        List valueAtPercentiles = summaryPoint.getPercentileValues();
        ArrayList<String> labelNamesWithQuantile = new ArrayList<String>(labelNames.size());
        labelNamesWithQuantile.addAll(labelNames);
        labelNamesWithQuantile.add(LABEL_NAME_QUANTILE);
        for (MetricData.ValueAtPercentile valueAtPercentile : valueAtPercentiles) {
            ArrayList<String> labelValuesWithQuantile = new ArrayList<String>(labelValues.size());
            labelValuesWithQuantile.addAll(labelValues);
            labelValuesWithQuantile.add(Collector.doubleToGoString((double)valueAtPercentile.getPercentile()));
            samples.add(new Collector.MetricFamilySamples.Sample(name, labelNamesWithQuantile, labelValuesWithQuantile, valueAtPercentile.getValue()));
        }
    }

    private static int estimateNumSamples(int numPoints, MetricData.Type type) {
        if (type == MetricData.Type.SUMMARY) {
            return numPoints * 4;
        }
        return numPoints;
    }

    private MetricAdapter() {
    }

    private static final class Consumer
    implements BiConsumer<String, String> {
        final List<String> labelNames;
        final List<String> labelValues;

        private Consumer(List<String> labelNames, List<String> labelValues) {
            this.labelNames = labelNames;
            this.labelValues = labelValues;
        }

        @Override
        public void accept(String key, String value) {
            this.labelNames.add(MetricAdapter.toLabelName(key));
            this.labelValues.add(value == null ? "" : value);
        }
    }
}

