/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.trace;

import com.google.common.base.Splitter;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyChannelBuilder;
import io.grpc.stub.MetadataUtils;
import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter;
import io.opentelemetry.sdk.common.export.ConfigBuilder;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.net.ssl.SSLException;

public final class OtlpGrpcSpanExporterBuilder
extends ConfigBuilder<OtlpGrpcSpanExporterBuilder> {
    private static final String DEFAULT_ENDPOINT = "localhost:4317";
    private static final long DEFAULT_TIMEOUT_SECS = 10L;
    private static final String KEY_TIMEOUT = "otel.exporter.otlp.span.timeout";
    private static final String KEY_ENDPOINT = "otel.exporter.otlp.span.endpoint";
    private static final String KEY_INSECURE = "otel.exporter.otlp.span.insecure";
    private static final String KEY_HEADERS = "otel.exporter.otlp.span.headers";
    private ManagedChannel channel;
    private long timeoutNanos = TimeUnit.SECONDS.toNanos(10L);
    private String endpoint = "localhost:4317";
    private boolean useTls = false;
    @Nullable
    private Metadata metadata;
    @Nullable
    private byte[] trustedCertificatesPem;

    public OtlpGrpcSpanExporterBuilder setChannel(ManagedChannel channel) {
        this.channel = channel;
        return this;
    }

    public OtlpGrpcSpanExporterBuilder setTimeout(long timeout, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        Utils.checkArgument((timeout >= 0L ? 1 : 0) != 0, (String)"timeout must be non-negative");
        this.timeoutNanos = unit.toNanos(timeout);
        return this;
    }

    public OtlpGrpcSpanExporterBuilder setTimeout(Duration timeout) {
        Objects.requireNonNull(timeout, "timeout");
        return this.setTimeout(timeout.toNanos(), TimeUnit.NANOSECONDS);
    }

    @Deprecated
    public OtlpGrpcSpanExporterBuilder setDeadlineMs(long deadlineMs) {
        return this.setTimeout(Duration.ofMillis(deadlineMs));
    }

    public OtlpGrpcSpanExporterBuilder setEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public OtlpGrpcSpanExporterBuilder setUseTls(boolean useTls) {
        this.useTls = useTls;
        return this;
    }

    public OtlpGrpcSpanExporterBuilder setTrustedCertificates(byte[] trustedCertificatesPem) {
        this.trustedCertificatesPem = trustedCertificatesPem;
        return this;
    }

    public OtlpGrpcSpanExporterBuilder addHeader(String key, String value) {
        if (this.metadata == null) {
            this.metadata = new Metadata();
        }
        this.metadata.put(Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)value);
        return this;
    }

    public OtlpGrpcSpanExporter build() {
        if (this.channel == null) {
            ManagedChannelBuilder managedChannelBuilder = ManagedChannelBuilder.forTarget((String)this.endpoint);
            if (this.useTls) {
                managedChannelBuilder.useTransportSecurity();
            } else {
                managedChannelBuilder.usePlaintext();
            }
            if (this.metadata != null) {
                managedChannelBuilder.intercept(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)this.metadata)});
            }
            if (this.trustedCertificatesPem != null) {
                if (managedChannelBuilder.getClass().getName().equals("io.grpc.netty.NettyChannelBuilder")) {
                    NettyChannelBuilder nettyBuilder = (NettyChannelBuilder)managedChannelBuilder;
                    try {
                        nettyBuilder.sslContext(GrpcSslContexts.forClient().trustManager((InputStream)new ByteArrayInputStream(this.trustedCertificatesPem)).build());
                    }
                    catch (IllegalArgumentException | SSLException e) {
                        throw new IllegalStateException("Could not set trusted certificates for gRPC TLS connection, are they valid X.509 in PEM format?", e);
                    }
                } else if (managedChannelBuilder.getClass().getName().equals("io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder")) {
                    io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder nettyBuilder = (io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder)managedChannelBuilder;
                    try {
                        nettyBuilder.sslContext(io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts.forClient().trustManager((InputStream)new ByteArrayInputStream(this.trustedCertificatesPem)).build());
                    }
                    catch (IllegalArgumentException | SSLException e) {
                        throw new IllegalStateException("Could not set trusted certificates for gRPC TLS connection, are they valid X.509 in PEM format?", e);
                    }
                } else {
                    throw new IllegalStateException("TLS cerificate configuration only supported with Netty. If you need to configure a certificate, switch to grpc-netty or grpc-netty-shaded.");
                }
            }
            this.channel = managedChannelBuilder.build();
        }
        return new OtlpGrpcSpanExporter(this.channel, this.timeoutNanos);
    }

    OtlpGrpcSpanExporterBuilder() {
    }

    protected OtlpGrpcSpanExporterBuilder fromConfigMap(Map<String, String> configMap, ConfigBuilder.NamingConvention namingConvention) {
        String metadataValue;
        Boolean insecure;
        String endpointValue;
        Long value = OtlpGrpcSpanExporterBuilder.getLongProperty((String)KEY_TIMEOUT, (Map)(configMap = namingConvention.normalize(configMap)));
        if (value == null) {
            value = OtlpGrpcSpanExporterBuilder.getLongProperty((String)"otel.exporter.otlp.timeout", (Map)configMap);
        }
        if (value != null) {
            this.setTimeout(Duration.ofMillis(value));
        }
        if ((endpointValue = OtlpGrpcSpanExporterBuilder.getStringProperty((String)KEY_ENDPOINT, (Map)configMap)) == null) {
            endpointValue = OtlpGrpcSpanExporterBuilder.getStringProperty((String)"otel.exporter.otlp.endpoint", (Map)configMap);
        }
        if (endpointValue != null) {
            this.setEndpoint(endpointValue);
        }
        if ((insecure = OtlpGrpcSpanExporterBuilder.getBooleanProperty((String)KEY_INSECURE, (Map)configMap)) == null) {
            insecure = OtlpGrpcSpanExporterBuilder.getBooleanProperty((String)"otel.exporter.otlp.insecure", (Map)configMap);
        }
        if (insecure != null) {
            this.setUseTls(insecure == false);
        }
        if ((metadataValue = OtlpGrpcSpanExporterBuilder.getStringProperty((String)KEY_HEADERS, (Map)configMap)) == null) {
            metadataValue = OtlpGrpcSpanExporterBuilder.getStringProperty((String)"otel.exporter.otlp.headers", (Map)configMap);
        }
        if (metadataValue != null) {
            for (String keyValueString : Splitter.on((char)',').split((CharSequence)metadataValue)) {
                List keyValue = Splitter.on((char)'=').limit(2).trimResults().omitEmptyStrings().splitToList((CharSequence)keyValueString);
                if (keyValue.size() != 2) continue;
                this.addHeader((String)keyValue.get(0), (String)keyValue.get(1));
            }
        }
        return this;
    }
}

