/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.trace;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.grpc.Channel;
import io.grpc.ConnectivityState;
import io.grpc.ManagedChannel;
import io.opentelemetry.api.common.Labels;
import io.opentelemetry.api.metrics.GlobalMetricsProvider;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporterBuilder;
import io.opentelemetry.proto.collector.trace.v1.ExportTraceServiceRequest;
import io.opentelemetry.proto.collector.trace.v1.ExportTraceServiceResponse;
import io.opentelemetry.proto.collector.trace.v1.TraceServiceGrpc;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.extension.otproto.SpanAdapter;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OtlpGrpcSpanExporter
implements SpanExporter {
    public static final String DEFAULT_ENDPOINT = "localhost:4317";
    public static final long DEFAULT_DEADLINE_MS = TimeUnit.SECONDS.toMillis(10L);
    private static final Logger logger = Logger.getLogger(OtlpGrpcSpanExporter.class.getName());
    private static final String EXPORTER_NAME = OtlpGrpcSpanExporter.class.getSimpleName();
    private static final Labels EXPORTER_NAME_LABELS = Labels.of((String)"exporter", (String)EXPORTER_NAME);
    private static final Labels EXPORT_SUCCESS_LABELS = Labels.of((String)"exporter", (String)EXPORTER_NAME, (String)"success", (String)"true");
    private static final Labels EXPORT_FAILURE_LABELS = Labels.of((String)"exporter", (String)EXPORTER_NAME, (String)"success", (String)"false");
    private final TraceServiceGrpc.TraceServiceFutureStub traceService;
    private final ManagedChannel managedChannel;
    private final long deadlineMs;
    private final LongCounter.BoundLongCounter spansSeen;
    private final LongCounter.BoundLongCounter spansExportedSuccess;
    private final LongCounter.BoundLongCounter spansExportedFailure;

    OtlpGrpcSpanExporter(ManagedChannel channel, long deadlineMs) {
        Meter meter = GlobalMetricsProvider.getMeter((String)"io.opentelemetry.exporters.otlp");
        this.spansSeen = meter.longCounterBuilder("spansSeenByExporter").build().bind(EXPORTER_NAME_LABELS);
        LongCounter spansExportedCounter = meter.longCounterBuilder("spansExportedByExporter").build();
        this.spansExportedSuccess = spansExportedCounter.bind(EXPORT_SUCCESS_LABELS);
        this.spansExportedFailure = spansExportedCounter.bind(EXPORT_FAILURE_LABELS);
        this.managedChannel = channel;
        this.deadlineMs = deadlineMs;
        this.traceService = TraceServiceGrpc.newFutureStub((Channel)channel);
    }

    public CompletableResultCode export(final Collection<SpanData> spans) {
        this.spansSeen.add((long)spans.size());
        ExportTraceServiceRequest exportTraceServiceRequest = ExportTraceServiceRequest.newBuilder().addAllResourceSpans((Iterable)SpanAdapter.toProtoResourceSpans(spans)).build();
        final CompletableResultCode result = new CompletableResultCode();
        TraceServiceGrpc.TraceServiceFutureStub exporter = this.deadlineMs > 0L ? (TraceServiceGrpc.TraceServiceFutureStub)this.traceService.withDeadlineAfter(this.deadlineMs, TimeUnit.MILLISECONDS) : this.traceService;
        Futures.addCallback((ListenableFuture)exporter.export(exportTraceServiceRequest), (FutureCallback)new FutureCallback<ExportTraceServiceResponse>(){

            public void onSuccess(@Nullable ExportTraceServiceResponse response) {
                OtlpGrpcSpanExporter.this.spansExportedSuccess.add((long)spans.size());
                result.succeed();
            }

            public void onFailure(Throwable t) {
                OtlpGrpcSpanExporter.this.spansExportedFailure.add((long)spans.size());
                logger.log(Level.WARNING, "Failed to export spans. Error message: " + t.getMessage());
                logger.log(Level.FINEST, "Failed to export spans. Details follow: " + t);
                result.fail();
            }
        }, (Executor)MoreExecutors.directExecutor());
        return result;
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public static OtlpGrpcSpanExporterBuilder builder() {
        return new OtlpGrpcSpanExporterBuilder();
    }

    public static OtlpGrpcSpanExporter getDefault() {
        return ((OtlpGrpcSpanExporterBuilder)((Object)((OtlpGrpcSpanExporterBuilder)((Object)OtlpGrpcSpanExporter.builder().readEnvironmentVariables())).readSystemProperties())).build();
    }

    public CompletableResultCode shutdown() {
        CompletableResultCode result = new CompletableResultCode();
        this.managedChannel.notifyWhenStateChanged(ConnectivityState.SHUTDOWN, () -> ((CompletableResultCode)result).succeed());
        this.managedChannel.shutdown();
        this.spansSeen.unbind();
        this.spansExportedSuccess.unbind();
        this.spansExportedFailure.unbind();
        return result;
    }

    long getDeadlineMs() {
        return this.deadlineMs;
    }
}

