/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.metrics;

import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.stub.MetadataUtils;
import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporter;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class OtlpGrpcMetricExporterBuilder {
    private static final Logger logger = Logger.getLogger(OtlpGrpcMetricExporterBuilder.class.getName());
    private static final String DEFAULT_ENDPOINT_URL = "http://localhost:4317";
    private static final URI DEFAULT_ENDPOINT = URI.create("http://localhost:4317");
    private static final long DEFAULT_TIMEOUT_SECS = 10L;
    private ManagedChannel channel;
    private long timeoutNanos = TimeUnit.SECONDS.toNanos(10L);
    private URI endpoint = DEFAULT_ENDPOINT;
    @Nullable
    private Metadata metadata;

    public OtlpGrpcMetricExporterBuilder setChannel(ManagedChannel channel) {
        this.channel = channel;
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setTimeout(long timeout, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        Utils.checkArgument((timeout >= 0L ? 1 : 0) != 0, (String)"timeout must be non-negative");
        this.timeoutNanos = unit.toNanos(timeout);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setTimeout(Duration timeout) {
        Objects.requireNonNull(timeout, "timeout");
        return this.setTimeout(timeout.toNanos(), TimeUnit.NANOSECONDS);
    }

    public OtlpGrpcMetricExporterBuilder setEndpoint(String endpoint) {
        URI uri;
        Objects.requireNonNull(endpoint, "endpoint");
        try {
            uri = new URI(endpoint);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid endpoint, must be a URL: " + endpoint, e);
        }
        if (uri.getScheme() != null) {
            if (!uri.getScheme().equals("http") && !uri.getScheme().equals("https")) {
                throw new IllegalArgumentException("Invalid scheme, must be http or https: " + endpoint);
            }
        } else {
            logger.log(Level.WARNING, "Endpoints must have a scheme of http:// or https://. Endpoints without schemes will not be permitted in a future version of the SDK.", new Throwable());
        }
        this.endpoint = uri;
        return this;
    }

    public OtlpGrpcMetricExporterBuilder addHeader(String key, String value) {
        if (this.metadata == null) {
            this.metadata = new Metadata();
        }
        this.metadata.put(Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)value);
        return this;
    }

    public OtlpGrpcMetricExporter build() {
        if (this.channel == null) {
            ManagedChannelBuilder managedChannelBuilder = ManagedChannelBuilder.forTarget((String)this.endpoint.getAuthority());
            if (this.endpoint.getScheme().equals("https")) {
                managedChannelBuilder.useTransportSecurity();
            } else {
                managedChannelBuilder.usePlaintext();
            }
            if (this.metadata != null) {
                managedChannelBuilder.intercept(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)this.metadata)});
            }
            this.channel = managedChannelBuilder.build();
        }
        return new OtlpGrpcMetricExporter(this.channel, this.timeoutNanos);
    }

    OtlpGrpcMetricExporterBuilder() {
    }
}

