/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.metrics;

import com.google.common.base.Splitter;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.stub.MetadataUtils;
import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporter;
import io.opentelemetry.sdk.common.export.ConfigBuilder;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public final class OtlpGrpcMetricExporterBuilder
extends ConfigBuilder<OtlpGrpcMetricExporterBuilder> {
    private static final String DEFAULT_ENDPOINT = "localhost:4317";
    private static final long DEFAULT_TIMEOUT_SECS = 10L;
    private static final String KEY_TIMEOUT = "otel.exporter.otlp.metric.timeout";
    private static final String KEY_ENDPOINT = "otel.exporter.otlp.metric.endpoint";
    private static final String KEY_INSECURE = "otel.exporter.otlp.metric.insecure";
    private static final String KEY_HEADERS = "otel.exporter.otlp.metric.headers";
    private ManagedChannel channel;
    private long timeoutNanos = TimeUnit.SECONDS.toNanos(10L);
    private String endpoint = "localhost:4317";
    private boolean useTls = false;
    @Nullable
    private Metadata metadata;

    public OtlpGrpcMetricExporterBuilder setChannel(ManagedChannel channel) {
        this.channel = channel;
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setTimeout(long timeout, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        Utils.checkArgument((timeout >= 0L ? 1 : 0) != 0, (String)"timeout must be non-negative");
        this.timeoutNanos = unit.toNanos(timeout);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setTimeout(Duration timeout) {
        Objects.requireNonNull(timeout, "timeout");
        return this.setTimeout(timeout.toNanos(), TimeUnit.NANOSECONDS);
    }

    @Deprecated
    public OtlpGrpcMetricExporterBuilder setDeadlineMs(long deadlineMs) {
        return this.setTimeout(Duration.ofMillis(deadlineMs));
    }

    public OtlpGrpcMetricExporterBuilder setEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setUseTls(boolean useTls) {
        this.useTls = useTls;
        return this;
    }

    public OtlpGrpcMetricExporterBuilder addHeader(String key, String value) {
        if (this.metadata == null) {
            this.metadata = new Metadata();
        }
        this.metadata.put(Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)value);
        return this;
    }

    public OtlpGrpcMetricExporter build() {
        if (this.channel == null) {
            ManagedChannelBuilder managedChannelBuilder = ManagedChannelBuilder.forTarget((String)this.endpoint);
            if (this.useTls) {
                managedChannelBuilder.useTransportSecurity();
            } else {
                managedChannelBuilder.usePlaintext();
            }
            if (this.metadata != null) {
                managedChannelBuilder.intercept(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)this.metadata)});
            }
            this.channel = managedChannelBuilder.build();
        }
        return new OtlpGrpcMetricExporter(this.channel, this.timeoutNanos);
    }

    OtlpGrpcMetricExporterBuilder() {
    }

    protected OtlpGrpcMetricExporterBuilder fromConfigMap(Map<String, String> configMap, ConfigBuilder.NamingConvention namingConvention) {
        String metadataValue;
        Boolean insecure;
        String endpointValue;
        Long value = OtlpGrpcMetricExporterBuilder.getLongProperty((String)KEY_TIMEOUT, (Map)(configMap = namingConvention.normalize(configMap)));
        if (value == null) {
            value = OtlpGrpcMetricExporterBuilder.getLongProperty((String)"otel.exporter.otlp.timeout", (Map)configMap);
        }
        if (value != null) {
            this.setTimeout(Duration.ofMillis(value));
        }
        if ((endpointValue = OtlpGrpcMetricExporterBuilder.getStringProperty((String)KEY_ENDPOINT, (Map)configMap)) == null) {
            endpointValue = OtlpGrpcMetricExporterBuilder.getStringProperty((String)"otel.exporter.otlp.endpoint", (Map)configMap);
        }
        if (endpointValue != null) {
            this.setEndpoint(endpointValue);
        }
        if ((insecure = OtlpGrpcMetricExporterBuilder.getBooleanProperty((String)KEY_INSECURE, (Map)configMap)) == null) {
            insecure = OtlpGrpcMetricExporterBuilder.getBooleanProperty((String)"otel.exporter.otlp.insecure", (Map)configMap);
        }
        if (insecure != null) {
            this.setUseTls(insecure == false);
        }
        if ((metadataValue = OtlpGrpcMetricExporterBuilder.getStringProperty((String)KEY_HEADERS, (Map)configMap)) == null) {
            metadataValue = OtlpGrpcMetricExporterBuilder.getStringProperty((String)"otel.exporter.otlp.headers", (Map)configMap);
        }
        if (metadataValue != null) {
            for (String keyValueString : Splitter.on((char)',').split((CharSequence)metadataValue)) {
                List keyValue = Splitter.on((char)'=').limit(2).trimResults().omitEmptyStrings().splitToList((CharSequence)keyValueString);
                if (keyValue.size() != 2) continue;
                this.addHeader((String)keyValue.get(0), (String)keyValue.get(1));
            }
        }
        return this;
    }
}

