/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.internal.metrics;

import io.opentelemetry.exporter.otlp.internal.KeyValueMarshaler;
import io.opentelemetry.exporter.otlp.internal.Marshaler;
import io.opentelemetry.exporter.otlp.internal.MarshalerUtil;
import io.opentelemetry.exporter.otlp.internal.MarshalerWithSize;
import io.opentelemetry.exporter.otlp.internal.ProtoFieldInfo;
import io.opentelemetry.exporter.otlp.internal.Serializer;
import io.opentelemetry.proto.metrics.v1.internal.Exemplar;
import io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import io.opentelemetry.sdk.metrics.data.ExemplarData;
import io.opentelemetry.sdk.metrics.data.LongExemplarData;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;

final class ExemplarMarshaler
extends MarshalerWithSize {
    private final long timeUnixNano;
    private final ExemplarData value;
    private final ProtoFieldInfo valueField;
    @Nullable
    private final String spanId;
    @Nullable
    private final String traceId;
    private final KeyValueMarshaler[] filteredAttributeMarshalers;

    static ExemplarMarshaler[] createRepeated(List<ExemplarData> exemplars) {
        int numExemplars = exemplars.size();
        ExemplarMarshaler[] marshalers = new ExemplarMarshaler[numExemplars];
        for (int i = 0; i < numExemplars; ++i) {
            marshalers[i] = ExemplarMarshaler.create(exemplars.get(i));
        }
        return marshalers;
    }

    private static ExemplarMarshaler create(ExemplarData exemplar) {
        ProtoFieldInfo valueField;
        KeyValueMarshaler[] attributeMarshalers = KeyValueMarshaler.createRepeated(exemplar.getFilteredAttributes());
        if (exemplar instanceof LongExemplarData) {
            valueField = Exemplar.AS_INT;
        } else {
            assert (exemplar instanceof DoubleExemplarData);
            valueField = Exemplar.AS_DOUBLE;
        }
        return new ExemplarMarshaler(exemplar.getEpochNanos(), exemplar, valueField, exemplar.getSpanId(), exemplar.getTraceId(), attributeMarshalers);
    }

    private ExemplarMarshaler(long timeUnixNano, ExemplarData value, ProtoFieldInfo valueField, @Nullable String spanId, @Nullable String traceId, KeyValueMarshaler[] filteredAttributeMarshalers) {
        super(ExemplarMarshaler.calculateSize(timeUnixNano, valueField, value, spanId, traceId, filteredAttributeMarshalers));
        this.timeUnixNano = timeUnixNano;
        this.value = value;
        this.valueField = valueField;
        this.spanId = spanId;
        this.traceId = traceId;
        this.filteredAttributeMarshalers = filteredAttributeMarshalers;
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        output.serializeFixed64(Exemplar.TIME_UNIX_NANO, this.timeUnixNano);
        if (this.valueField == Exemplar.AS_INT) {
            output.serializeFixed64(this.valueField, ((LongExemplarData)this.value).getValue());
        } else {
            output.serializeDouble(this.valueField, ((DoubleExemplarData)this.value).getValue());
        }
        output.serializeSpanId(Exemplar.SPAN_ID, this.spanId);
        output.serializeTraceId(Exemplar.TRACE_ID, this.traceId);
        output.serializeRepeatedMessage(Exemplar.FILTERED_ATTRIBUTES, this.filteredAttributeMarshalers);
    }

    private static int calculateSize(long timeUnixNano, ProtoFieldInfo valueField, ExemplarData value, @Nullable String spanId, @Nullable String traceId, KeyValueMarshaler[] filteredAttributeMarshalers) {
        int size = 0;
        size += MarshalerUtil.sizeFixed64(Exemplar.TIME_UNIX_NANO, timeUnixNano);
        size = valueField == Exemplar.AS_INT ? (size += MarshalerUtil.sizeFixed64(valueField, ((LongExemplarData)value).getValue())) : (size += MarshalerUtil.sizeDouble(valueField, ((DoubleExemplarData)value).getValue()));
        size += MarshalerUtil.sizeSpanId(Exemplar.SPAN_ID, spanId);
        size += MarshalerUtil.sizeTraceId(Exemplar.TRACE_ID, traceId);
        return size += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)Exemplar.FILTERED_ATTRIBUTES, (Marshaler[])filteredAttributeMarshalers);
    }
}

