/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.internal.grpc;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.BoundLongCounter;
import io.opentelemetry.api.metrics.GlobalMeterProvider;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.exporter.otlp.internal.Marshaler;
import io.opentelemetry.exporter.otlp.internal.grpc.GrpcExporter;
import io.opentelemetry.exporter.otlp.internal.grpc.GrpcRequestBody;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.internal.ThrottlingLogger;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public final class OkHttpGrpcExporter<T extends Marshaler>
implements GrpcExporter<T> {
    private static final String GRPC_STATUS = "grpc-status";
    private static final String GRPC_MESSAGE = "grpc-message";
    private final ThrottlingLogger logger = new ThrottlingLogger(Logger.getLogger(OkHttpGrpcExporter.class.getName()));
    private final String type;
    private final OkHttpClient client;
    private final String endpoint;
    private final Headers headers;
    private final boolean compressionEnabled;
    private final BoundLongCounter seen;
    private final BoundLongCounter success;
    private final BoundLongCounter failed;

    OkHttpGrpcExporter(String type, OkHttpClient client, String endpoint, Headers headers, boolean compressionEnabled) {
        this.type = type;
        this.client = client;
        this.endpoint = endpoint;
        this.headers = headers;
        this.compressionEnabled = compressionEnabled;
        Meter meter = GlobalMeterProvider.get().get("io.opentelemetry.exporters.otlp-grpc-okhttp");
        Attributes attributes = Attributes.builder().put("type", type).build();
        this.seen = meter.counterBuilder("otlp.exporter.seen").build().bind(attributes);
        LongCounter exported = meter.counterBuilder("otlp.exported.exported").build();
        this.success = exported.bind(attributes.toBuilder().put("success", true).build());
        this.failed = exported.bind(attributes.toBuilder().put("success", false).build());
    }

    @Override
    public CompletableResultCode export(T exportRequest, final int numItems) {
        this.seen.add((long)numItems);
        Request.Builder requestBuilder = new Request.Builder().url(this.endpoint).headers(this.headers);
        GrpcRequestBody requestBody = new GrpcRequestBody((Marshaler)exportRequest, this.compressionEnabled);
        requestBuilder.post((RequestBody)requestBody);
        final CompletableResultCode result = new CompletableResultCode();
        this.client.newCall(requestBuilder.build()).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                OkHttpGrpcExporter.this.failed.add((long)numItems);
                OkHttpGrpcExporter.this.logger.log(Level.SEVERE, "Failed to export " + OkHttpGrpcExporter.this.type + "s. The request could not be executed. Full error message: " + e.getMessage());
                result.fail();
            }

            public void onResponse(Call call, Response response) {
                try {
                    response.body().bytes();
                }
                catch (IOException e) {
                    OkHttpGrpcExporter.this.logger.log(Level.WARNING, "Failed to export " + OkHttpGrpcExporter.this.type + "s, could not consume server response.", (Throwable)e);
                    OkHttpGrpcExporter.this.failed.add((long)numItems);
                    result.fail();
                    return;
                }
                String status = OkHttpGrpcExporter.grpcStatus(response);
                if ("0".equals(status)) {
                    OkHttpGrpcExporter.this.success.add((long)numItems);
                    result.succeed();
                    return;
                }
                OkHttpGrpcExporter.this.failed.add((long)numItems);
                String codeMessage = status != null ? "gRPC status code " + status : "HTTP status code " + response.code();
                String errorMessage = OkHttpGrpcExporter.grpcMessage(response);
                OkHttpGrpcExporter.this.logger.log(Level.WARNING, "Failed to export " + OkHttpGrpcExporter.this.type + "s. Server responded with " + codeMessage + ". Error message: " + errorMessage);
                result.fail();
            }
        });
        return result;
    }

    @Nullable
    private static String grpcStatus(Response response) {
        String grpcStatus = response.header(GRPC_STATUS);
        if (grpcStatus == null) {
            try {
                grpcStatus = response.trailers().get(GRPC_STATUS);
            }
            catch (IOException e) {
                return null;
            }
        }
        return grpcStatus;
    }

    private static String grpcMessage(Response response) {
        String message = response.header(GRPC_MESSAGE);
        if (message == null) {
            try {
                message = response.trailers().get(GRPC_MESSAGE);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (message != null) {
            return OkHttpGrpcExporter.unescape(message);
        }
        return response.message();
    }

    @Override
    public CompletableResultCode shutdown() {
        this.client.dispatcher().cancelAll();
        this.client.dispatcher().executorService().shutdownNow();
        this.seen.unbind();
        this.success.unbind();
        this.failed.unbind();
        return CompletableResultCode.ofSuccess();
    }

    private static String unescape(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c >= ' ' && c < '~' && (c != '%' || i + 2 >= value.length())) continue;
            return OkHttpGrpcExporter.doUnescape(value.getBytes(StandardCharsets.US_ASCII));
        }
        return value;
    }

    private static String doUnescape(byte[] value) {
        ByteBuffer buf = ByteBuffer.allocate(value.length);
        int i = 0;
        while (i < value.length) {
            if (value[i] == 37 && i + 2 < value.length) {
                try {
                    buf.put((byte)Integer.parseInt(new String(value, i + 1, 2, StandardCharsets.UTF_8), 16));
                    i += 3;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            buf.put(value[i]);
            ++i;
        }
        return new String(buf.array(), 0, buf.position(), StandardCharsets.UTF_8);
    }
}

