/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.internal;

import io.opentelemetry.exporter.otlp.internal.Marshaler;
import io.opentelemetry.exporter.otlp.internal.ProtoEnumInfo;
import io.opentelemetry.exporter.otlp.internal.ProtoFieldInfo;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;

public abstract class Serializer
implements AutoCloseable {
    Serializer() {
    }

    public void serializeTraceId(ProtoFieldInfo field, @Nullable String traceId) throws IOException {
        if (traceId == null) {
            return;
        }
        this.writeTraceId(field, traceId);
    }

    protected abstract void writeTraceId(ProtoFieldInfo var1, String var2) throws IOException;

    public void serializeSpanId(ProtoFieldInfo field, @Nullable String spanId) throws IOException {
        if (spanId == null) {
            return;
        }
        this.writeSpanId(field, spanId);
    }

    protected abstract void writeSpanId(ProtoFieldInfo var1, String var2) throws IOException;

    public void serializeBool(ProtoFieldInfo field, boolean value) throws IOException {
        if (!value) {
            return;
        }
        this.writeBool(field, value);
    }

    protected abstract void writeBool(ProtoFieldInfo var1, boolean var2) throws IOException;

    public void serializeEnum(ProtoFieldInfo field, ProtoEnumInfo enumValue) throws IOException {
        if (enumValue.getEnumNumber() == 0) {
            return;
        }
        this.writeEnum(field, enumValue);
    }

    protected abstract void writeEnum(ProtoFieldInfo var1, ProtoEnumInfo var2) throws IOException;

    public void serializeUInt32(ProtoFieldInfo field, int value) throws IOException {
        if (value == 0) {
            return;
        }
        this.writeUint32(field, value);
    }

    protected abstract void writeUint32(ProtoFieldInfo var1, int var2) throws IOException;

    public void serializeInt32(ProtoFieldInfo field, int value) throws IOException {
        if (value == 0) {
            return;
        }
        this.writeint32(field, value);
    }

    protected abstract void writeint32(ProtoFieldInfo var1, int var2) throws IOException;

    public void serializeInt64(ProtoFieldInfo field, long value) throws IOException {
        if (value == 0L) {
            return;
        }
        this.writeInt64(field, value);
    }

    protected abstract void writeInt64(ProtoFieldInfo var1, long var2) throws IOException;

    public void serializeFixed64(ProtoFieldInfo field, long value) throws IOException {
        if (value == 0L) {
            return;
        }
        this.writeFixed64(field, value);
    }

    protected abstract void writeFixed64(ProtoFieldInfo var1, long var2) throws IOException;

    protected abstract void writeFixed64Value(long var1) throws IOException;

    public void serializeFixed32(ProtoFieldInfo field, int value) throws IOException {
        if (value == 0) {
            return;
        }
        this.writeFixed32(field, value);
    }

    protected abstract void writeFixed32(ProtoFieldInfo var1, int var2) throws IOException;

    public void serializeDouble(ProtoFieldInfo field, double value) throws IOException {
        if (value == 0.0) {
            return;
        }
        this.writeDouble(field, value);
    }

    protected abstract void writeDouble(ProtoFieldInfo var1, double var2) throws IOException;

    protected abstract void writeDoubleValue(double var1) throws IOException;

    public void serializeString(ProtoFieldInfo field, byte[] utf8Bytes) throws IOException {
        if (utf8Bytes.length == 0) {
            return;
        }
        this.writeString(field, utf8Bytes);
    }

    protected abstract void writeString(ProtoFieldInfo var1, byte[] var2) throws IOException;

    public void serializeBytes(ProtoFieldInfo field, byte[] value) throws IOException {
        if (value.length == 0) {
            return;
        }
        this.writeBytes(field, value);
    }

    protected abstract void writeBytes(ProtoFieldInfo var1, byte[] var2) throws IOException;

    protected abstract void writeStartMessage(ProtoFieldInfo var1, int var2) throws IOException;

    protected abstract void writeEndMessage() throws IOException;

    public void serializeMessage(ProtoFieldInfo field, Marshaler message) throws IOException {
        this.writeStartMessage(field, message.getBinarySerializedSize());
        message.writeTo(this);
        this.writeEndMessage();
    }

    protected abstract void writeStartRepeatedPrimitive(ProtoFieldInfo var1, int var2, int var3) throws IOException;

    protected abstract void writeEndRepeatedPrimitive() throws IOException;

    public void serializeRepeatedFixed64(ProtoFieldInfo field, List<Long> values) throws IOException {
        if (values.isEmpty()) {
            return;
        }
        this.writeStartRepeatedPrimitive(field, 8, values.size());
        for (long value : values) {
            this.writeFixed64Value(value);
        }
        this.writeEndRepeatedPrimitive();
    }

    public void serializeRepeatedDouble(ProtoFieldInfo field, List<Double> values) throws IOException {
        if (values.isEmpty()) {
            return;
        }
        this.writeStartRepeatedPrimitive(field, 8, values.size());
        for (double value : values) {
            this.writeDoubleValue(value);
        }
        this.writeEndRepeatedPrimitive();
    }

    public abstract void serializeRepeatedMessage(ProtoFieldInfo var1, Marshaler[] var2) throws IOException;

    public abstract void serializeRepeatedMessage(ProtoFieldInfo var1, List<? extends Marshaler> var2) throws IOException;

    public abstract void writeSerializedMessage(byte[] var1, String var2) throws IOException;

    @Override
    public abstract void close() throws IOException;
}

