/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.internal;

import com.google.protobuf.ByteString;
import com.google.protobuf.UnsafeByteOperations;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.exporter.otlp.internal.CommonAdapter;
import io.opentelemetry.exporter.otlp.internal.ResourceAdapter;
import io.opentelemetry.proto.trace.v1.InstrumentationLibrarySpans;
import io.opentelemetry.proto.trace.v1.ResourceSpans;
import io.opentelemetry.proto.trace.v1.Span;
import io.opentelemetry.proto.trace.v1.Status;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.data.EventData;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.data.StatusData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public final class SpanAdapter {
    private static final ThreadLocal<ThreadLocalCache> THREAD_LOCAL_CACHE = new ThreadLocal();
    private static final Status STATUS_OK = Status.newBuilder().setCode(Status.StatusCode.STATUS_CODE_OK).setDeprecatedCode(Status.DeprecatedStatusCode.DEPRECATED_STATUS_CODE_OK).build();
    private static final Status STATUS_ERROR = Status.newBuilder().setCode(Status.StatusCode.STATUS_CODE_ERROR).setDeprecatedCode(Status.DeprecatedStatusCode.DEPRECATED_STATUS_CODE_UNKNOWN_ERROR).build();
    private static final Status STATUS_UNSET = Status.newBuilder().setCode(Status.StatusCode.STATUS_CODE_UNSET).setDeprecatedCode(Status.DeprecatedStatusCode.DEPRECATED_STATUS_CODE_OK).build();

    public static List<ResourceSpans> toProtoResourceSpans(Collection<SpanData> spanDataList) {
        Map<Resource, Map<InstrumentationLibraryInfo, List<Span>>> resourceAndLibraryMap = SpanAdapter.groupByResourceAndLibrary(spanDataList);
        ArrayList<ResourceSpans> resourceSpans = new ArrayList<ResourceSpans>(resourceAndLibraryMap.size());
        resourceAndLibraryMap.forEach((resource, librarySpans) -> {
            ResourceSpans.Builder resourceSpansBuilder = ResourceSpans.newBuilder().setResource(ResourceAdapter.toProtoResource(resource));
            if (resource.getSchemaUrl() != null) {
                resourceSpansBuilder.setSchemaUrl(resource.getSchemaUrl());
            }
            librarySpans.forEach((library, spans) -> resourceSpansBuilder.addInstrumentationLibrarySpans(SpanAdapter.buildInstrumentationLibrarySpan(library, spans)));
            resourceSpans.add(resourceSpansBuilder.build());
        });
        return resourceSpans;
    }

    private static InstrumentationLibrarySpans buildInstrumentationLibrarySpan(InstrumentationLibraryInfo library, List<Span> spans) {
        InstrumentationLibrarySpans.Builder spansBuilder = InstrumentationLibrarySpans.newBuilder().setInstrumentationLibrary(CommonAdapter.toProtoInstrumentationLibrary(library)).addAllSpans(spans);
        if (library.getSchemaUrl() != null) {
            spansBuilder.setSchemaUrl(library.getSchemaUrl());
        }
        return spansBuilder.build();
    }

    private static Map<Resource, Map<InstrumentationLibraryInfo, List<Span>>> groupByResourceAndLibrary(Collection<SpanData> spanDataList) {
        IdentityHashMap<Resource, Map<InstrumentationLibraryInfo, List<Span>>> result = new IdentityHashMap<Resource, Map<InstrumentationLibraryInfo, List<Span>>>(8);
        ThreadLocalCache threadLocalCache = SpanAdapter.getThreadLocalCache();
        for (SpanData spanData : spanDataList) {
            Map libraryInfoListMap = result.computeIfAbsent(spanData.getResource(), unused -> new IdentityHashMap(8));
            List spanList = libraryInfoListMap.computeIfAbsent(spanData.getInstrumentationLibraryInfo(), unused -> new ArrayList());
            spanList.add(SpanAdapter.toProtoSpan(spanData, threadLocalCache));
        }
        threadLocalCache.idBytesCache.clear();
        return result;
    }

    static Span toProtoSpan(SpanData spanData, ThreadLocalCache threadLocalCache) {
        Map<String, ByteString> idBytesCache = threadLocalCache.idBytesCache;
        Span.Builder builder = threadLocalCache.spanBuilder;
        builder.setTraceId(idBytesCache.computeIfAbsent(spanData.getSpanContext().getTraceId(), unused -> UnsafeByteOperations.unsafeWrap((byte[])spanData.getSpanContext().getTraceIdBytes())));
        builder.setSpanId(idBytesCache.computeIfAbsent(spanData.getSpanContext().getSpanId(), unused -> UnsafeByteOperations.unsafeWrap((byte[])spanData.getSpanContext().getSpanIdBytes())));
        if (spanData.getParentSpanContext().isValid()) {
            builder.setParentSpanId(idBytesCache.computeIfAbsent(spanData.getParentSpanContext().getSpanId(), unused -> UnsafeByteOperations.unsafeWrap((byte[])spanData.getParentSpanContext().getSpanIdBytes())));
        }
        builder.setName(spanData.getName());
        builder.setKind(SpanAdapter.toProtoSpanKind(spanData.getKind()));
        builder.setStartTimeUnixNano(spanData.getStartEpochNanos());
        builder.setEndTimeUnixNano(spanData.getEndEpochNanos());
        spanData.getAttributes().forEach((key, value) -> builder.addAttributes(CommonAdapter.toProtoAttribute(key, value)));
        builder.setDroppedAttributesCount(spanData.getTotalAttributeCount() - spanData.getAttributes().size());
        for (EventData event : spanData.getEvents()) {
            builder.addEvents(SpanAdapter.toProtoSpanEvent(event, threadLocalCache));
        }
        builder.setDroppedEventsCount(spanData.getTotalRecordedEvents() - spanData.getEvents().size());
        for (LinkData link : spanData.getLinks()) {
            builder.addLinks(SpanAdapter.toProtoSpanLink(link, threadLocalCache));
        }
        builder.setDroppedLinksCount(spanData.getTotalRecordedLinks() - spanData.getLinks().size());
        builder.setStatus(SpanAdapter.toStatusProto(spanData.getStatus()));
        Span span = builder.build();
        builder.clear();
        return span;
    }

    static Span.SpanKind toProtoSpanKind(SpanKind kind) {
        switch (kind) {
            case INTERNAL: {
                return Span.SpanKind.SPAN_KIND_INTERNAL;
            }
            case SERVER: {
                return Span.SpanKind.SPAN_KIND_SERVER;
            }
            case CLIENT: {
                return Span.SpanKind.SPAN_KIND_CLIENT;
            }
            case PRODUCER: {
                return Span.SpanKind.SPAN_KIND_PRODUCER;
            }
            case CONSUMER: {
                return Span.SpanKind.SPAN_KIND_CONSUMER;
            }
        }
        return Span.SpanKind.UNRECOGNIZED;
    }

    static Span.Event toProtoSpanEvent(EventData event, ThreadLocalCache threadLocalCache) {
        Span.Event.Builder builder = threadLocalCache.spanEventBuilder;
        builder.setName(event.getName());
        builder.setTimeUnixNano(event.getEpochNanos());
        event.getAttributes().forEach((key, value) -> builder.addAttributes(CommonAdapter.toProtoAttribute(key, value)));
        builder.setDroppedAttributesCount(event.getTotalAttributeCount() - event.getAttributes().size());
        Span.Event built = builder.build();
        builder.clear();
        return built;
    }

    static Span.Link toProtoSpanLink(LinkData link, ThreadLocalCache threadLocalCache) {
        Map<String, ByteString> idBytesCache = threadLocalCache.idBytesCache;
        Span.Link.Builder builder = threadLocalCache.spanLinkBuilder;
        builder.setTraceId(idBytesCache.computeIfAbsent(link.getSpanContext().getTraceId(), unused -> UnsafeByteOperations.unsafeWrap((byte[])link.getSpanContext().getTraceIdBytes())));
        builder.setSpanId(idBytesCache.computeIfAbsent(link.getSpanContext().getSpanId(), unused -> UnsafeByteOperations.unsafeWrap((byte[])link.getSpanContext().getSpanIdBytes())));
        Attributes attributes = link.getAttributes();
        attributes.forEach((key, value) -> builder.addAttributes(CommonAdapter.toProtoAttribute(key, value)));
        builder.setDroppedAttributesCount(link.getTotalAttributeCount() - attributes.size());
        Span.Link built = builder.build();
        builder.clear();
        return built;
    }

    static Status toStatusProto(StatusData status) {
        Status withoutDescription;
        switch (status.getStatusCode()) {
            case OK: {
                withoutDescription = STATUS_OK;
                break;
            }
            case ERROR: {
                withoutDescription = STATUS_ERROR;
                break;
            }
            default: {
                withoutDescription = STATUS_UNSET;
            }
        }
        if (status.getDescription().isEmpty()) {
            return withoutDescription;
        }
        return withoutDescription.toBuilder().setMessage(status.getDescription()).build();
    }

    private static ThreadLocalCache getThreadLocalCache() {
        ThreadLocalCache result = THREAD_LOCAL_CACHE.get();
        if (result == null) {
            result = new ThreadLocalCache();
            THREAD_LOCAL_CACHE.set(result);
        }
        return result;
    }

    private SpanAdapter() {
    }

    static final class ThreadLocalCache {
        final Map<String, ByteString> idBytesCache = new HashMap<String, ByteString>();
        final Span.Builder spanBuilder = Span.newBuilder();
        final Span.Event.Builder spanEventBuilder = Span.Event.newBuilder();
        final Span.Link.Builder spanLinkBuilder = Span.Link.newBuilder();

        ThreadLocalCache() {
        }
    }
}

