/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.internal.okhttp;

import io.opentelemetry.exporter.otlp.internal.RetryPolicy;
import java.io.IOException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import okhttp3.Interceptor;
import okhttp3.Response;

public final class RetryInterceptor
implements Interceptor {
    private final RetryPolicy retryPolicy;
    private final Function<Response, Boolean> isRetryable;
    private final Sleeper sleeper;
    private final BoundedLongGenerator randomLong;

    public RetryInterceptor(RetryPolicy retryPolicy, Function<Response, Boolean> isRetryable) {
        this(retryPolicy, isRetryable, TimeUnit.NANOSECONDS::sleep, bound -> ThreadLocalRandom.current().nextLong(bound));
    }

    RetryInterceptor(RetryPolicy retryPolicy, Function<Response, Boolean> isRetryable, Sleeper sleeper, BoundedLongGenerator randomLong) {
        this.retryPolicy = retryPolicy;
        this.isRetryable = isRetryable;
        this.sleeper = sleeper;
        this.randomLong = randomLong;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response = chain.proceed(chain.request());
        if (!Boolean.TRUE.equals(this.isRetryable.apply(response))) {
            return response;
        }
        long nextBackoffNanos = this.retryPolicy.getInitialBackoff().toNanos();
        for (int attempt = 2; attempt <= this.retryPolicy.getMaxAttempts(); ++attempt) {
            long upperBoundNanos = Math.min(nextBackoffNanos, this.retryPolicy.getMaxBackoff().toNanos());
            long backoffNanos = this.randomLong.get(upperBoundNanos);
            try {
                this.sleeper.sleep(backoffNanos);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return response;
            }
            response.close();
            response = chain.proceed(chain.request());
            if (!Boolean.TRUE.equals(this.isRetryable.apply(response))) {
                return response;
            }
            nextBackoffNanos = (long)((double)nextBackoffNanos * this.retryPolicy.getBackoffMultiplier());
        }
        return response;
    }

    static interface Sleeper {
        public void sleep(long var1) throws InterruptedException;
    }

    static interface BoundedLongGenerator {
        public long get(long var1);
    }
}

