/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.internal.grpc;

import io.opentelemetry.exporter.otlp.internal.CodedInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public final class GrpcStatusUtil {
    public static final String GRPC_STATUS_CANCELLED = "1";
    public static final String GRPC_STATUS_DEADLINE_EXCEEDED = "4";
    public static final String GRPC_STATUS_RESOURCE_EXHAUSTED = "8";
    public static final String GRPC_STATUS_ABORTED = "10";
    public static final String GRPC_STATUS_OUT_OF_RANGE = "11";
    public static final String GRPC_STATUS_UNIMPLEMENTED = "12";
    public static final String GRPC_STATUS_UNAVAILABLE = "14";
    public static final String GRPC_STATUS_DATA_LOSS = "15";
    private static final Set<String> RETRYABLE_STATUS_CODES = new HashSet<String>();

    public static Set<String> retryableStatusCodes() {
        return RETRYABLE_STATUS_CODES;
    }

    public static String getStatusMessage(byte[] serializedStatus) throws IOException {
        CodedInputStream input = CodedInputStream.newInstance(serializedStatus);
        boolean done = false;
        block4: while (!done) {
            int tag = input.readTag();
            switch (tag) {
                case 0: {
                    done = true;
                    continue block4;
                }
                case 18: {
                    return input.readStringRequireUtf8();
                }
            }
            input.skipField(tag);
        }
        return "";
    }

    private GrpcStatusUtil() {
    }

    static {
        RETRYABLE_STATUS_CODES.add(GRPC_STATUS_CANCELLED);
        RETRYABLE_STATUS_CODES.add(GRPC_STATUS_DEADLINE_EXCEEDED);
        RETRYABLE_STATUS_CODES.add(GRPC_STATUS_RESOURCE_EXHAUSTED);
        RETRYABLE_STATUS_CODES.add(GRPC_STATUS_ABORTED);
        RETRYABLE_STATUS_CODES.add(GRPC_STATUS_OUT_OF_RANGE);
        RETRYABLE_STATUS_CODES.add(GRPC_STATUS_UNAVAILABLE);
        RETRYABLE_STATUS_CODES.add(GRPC_STATUS_DATA_LOSS);
    }
}

