/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.logging.otlp.internal.logs;

import io.opentelemetry.exporter.logging.otlp.internal.logs.OtlpStdoutLogRecordExporter;
import io.opentelemetry.exporter.logging.otlp.internal.writer.JsonWriter;
import io.opentelemetry.exporter.logging.otlp.internal.writer.LoggerJsonWriter;
import io.opentelemetry.exporter.logging.otlp.internal.writer.StreamJsonWriter;
import java.io.OutputStream;
import java.util.Objects;
import java.util.logging.Logger;

public final class OtlpStdoutLogRecordExporterBuilder {
    private static final String TYPE = "log records";
    private final Logger logger;
    private JsonWriter jsonWriter;
    private boolean wrapperJsonObject = true;

    public OtlpStdoutLogRecordExporterBuilder(Logger logger) {
        this.logger = logger;
        this.jsonWriter = new LoggerJsonWriter(logger, TYPE);
    }

    public OtlpStdoutLogRecordExporterBuilder setWrapperJsonObject(boolean wrapperJsonObject) {
        this.wrapperJsonObject = wrapperJsonObject;
        return this;
    }

    public OtlpStdoutLogRecordExporterBuilder setOutput(OutputStream outputStream) {
        Objects.requireNonNull(outputStream, "outputStream");
        this.jsonWriter = new StreamJsonWriter(outputStream, TYPE);
        return this;
    }

    public OtlpStdoutLogRecordExporterBuilder setOutput(Logger logger) {
        Objects.requireNonNull(logger, "logger");
        this.jsonWriter = new LoggerJsonWriter(logger, TYPE);
        return this;
    }

    public OtlpStdoutLogRecordExporter build() {
        return new OtlpStdoutLogRecordExporter(this.logger, this.jsonWriter, this.wrapperJsonObject);
    }
}

