/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.context;

import io.opentelemetry.context.ContextExecutorService;
import io.opentelemetry.context.ContextKey;
import io.opentelemetry.context.ContextScheduledExecutorService;
import io.opentelemetry.context.ContextStorage;
import io.opentelemetry.context.DefaultContext;
import io.opentelemetry.context.Scope;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;

public interface Context {
    public static Context current() {
        Context current = ContextStorage.get().current();
        return current != null ? current : Context.root();
    }

    public static Context root() {
        return DefaultContext.ROOT;
    }

    @Nullable
    public <V> V getValue(ContextKey<V> var1);

    public <V> Context withValues(ContextKey<V> var1, V var2);

    default public <V1, V2> Context withValues(ContextKey<V1> k1, V1 v1, ContextKey<V2> k2, V2 v2) {
        return this.withValues(k1, v1).withValues(k2, v2);
    }

    default public <V1, V2, V3> Context withValues(ContextKey<V1> k1, V1 v1, ContextKey<V2> k2, V2 v2, ContextKey<V3> k3, V3 v3) {
        return this.withValues(k1, v1, k2, v2).withValues(k3, v3);
    }

    default public <V1, V2, V3, V4> Context withValues(ContextKey<V1> k1, V1 v1, ContextKey<V2> k2, V2 v2, ContextKey<V3> k3, V3 v3, ContextKey<V4> k4, V4 v4) {
        return this.withValues(k1, v1, k2, v2, k3, v3).withValues(k4, v4);
    }

    default public Scope makeCurrent() {
        return ContextStorage.get().attach(this);
    }

    default public Runnable wrap(Runnable runnable) {
        return () -> {
            try (Scope ignored = this.makeCurrent();){
                runnable.run();
            }
        };
    }

    default public <T> Callable<T> wrap(Callable<T> callable) {
        return () -> {
            try (Scope ignored = this.makeCurrent();){
                Object v = callable.call();
                return v;
            }
        };
    }

    default public Executor wrap(Executor executor) {
        return command -> executor.execute(this.wrap(command));
    }

    default public ExecutorService wrap(ExecutorService executor) {
        return new ContextExecutorService(this, executor);
    }

    default public ScheduledExecutorService wrap(ScheduledExecutorService executor) {
        return new ContextScheduledExecutorService(this, executor);
    }
}

