/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.common;

import io.opentelemetry.api.common.KeyValue;
import io.opentelemetry.api.common.Value;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.List;

final class JsonEncoding {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    static void append(StringBuilder sb, Value<?> value) {
        switch (value.getType()) {
            case STRING: {
                JsonEncoding.appendString(sb, (String)value.getValue());
                break;
            }
            case LONG: {
                sb.append(value.getValue());
                break;
            }
            case DOUBLE: {
                JsonEncoding.appendDouble(sb, (Double)value.getValue());
                break;
            }
            case BOOLEAN: {
                sb.append(value.getValue());
                break;
            }
            case ARRAY: {
                JsonEncoding.appendArray(sb, (List)value.getValue());
                break;
            }
            case KEY_VALUE_LIST: {
                JsonEncoding.appendMap(sb, (List)value.getValue());
                break;
            }
            case BYTES: {
                JsonEncoding.appendBytes(sb, (ByteBuffer)value.getValue());
                break;
            }
            case EMPTY: {
                sb.append("null");
            }
        }
    }

    private static void appendString(StringBuilder sb, String value) {
        sb.append('\"');
        block9: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        sb.append("\\u");
                        sb.append(HEX_DIGITS[c >> 12 & 0xF]);
                        sb.append(HEX_DIGITS[c >> 8 & 0xF]);
                        sb.append(HEX_DIGITS[c >> 4 & 0xF]);
                        sb.append(HEX_DIGITS[c & 0xF]);
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
    }

    private static void appendDouble(StringBuilder sb, double value) {
        if (Double.isNaN(value)) {
            sb.append("\"NaN\"");
        } else if (Double.isInfinite(value)) {
            sb.append(value > 0.0 ? "\"Infinity\"" : "\"-Infinity\"");
        } else {
            sb.append(value);
        }
    }

    private static void appendBytes(StringBuilder sb, ByteBuffer value) {
        byte[] bytes = new byte[value.remaining()];
        value.get(bytes);
        sb.append('\"').append(Base64.getEncoder().encodeToString(bytes)).append('\"');
    }

    private static void appendArray(StringBuilder sb, List<Value<?>> values) {
        sb.append('[');
        for (int i = 0; i < values.size(); ++i) {
            if (i > 0) {
                sb.append(',');
            }
            JsonEncoding.append(sb, values.get(i));
        }
        sb.append(']');
    }

    private static void appendMap(StringBuilder sb, List<KeyValue> values) {
        sb.append('{');
        for (int i = 0; i < values.size(); ++i) {
            if (i > 0) {
                sb.append(',');
            }
            KeyValue kv = values.get(i);
            JsonEncoding.appendString(sb, kv.getKey());
            sb.append(':');
            JsonEncoding.append(sb, kv.getValue());
        }
        sb.append('}');
    }

    private JsonEncoding() {
    }
}

