/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.common;

import com.google.auto.value.AutoValue;
import io.opentelemetry.common.AttributeValue;
import io.opentelemetry.common.AutoValue_Attributes_ArrayBackedAttributes;
import io.opentelemetry.common.ImmutableKeyValuePairs;
import io.opentelemetry.common.ReadableAttributes;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class Attributes
extends ImmutableKeyValuePairs<AttributeValue>
implements ReadableAttributes {
    private static final Attributes EMPTY = Attributes.newBuilder().build();

    public static Attributes empty() {
        return EMPTY;
    }

    public static Attributes of(String key, AttributeValue value) {
        return Attributes.sortAndFilterToAttributes(key, value);
    }

    public static Attributes of(String key1, AttributeValue value1, String key2, AttributeValue value2) {
        return Attributes.sortAndFilterToAttributes(key1, value1, key2, value2);
    }

    public static Attributes of(String key1, AttributeValue value1, String key2, AttributeValue value2, String key3, AttributeValue value3) {
        return Attributes.sortAndFilterToAttributes(key1, value1, key2, value2, key3, value3);
    }

    public static Attributes of(String key1, AttributeValue value1, String key2, AttributeValue value2, String key3, AttributeValue value3, String key4, AttributeValue value4) {
        return Attributes.sortAndFilterToAttributes(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public static Attributes of(String key1, AttributeValue value1, String key2, AttributeValue value2, String key3, AttributeValue value3, String key4, AttributeValue value4, String key5, AttributeValue value5) {
        return Attributes.sortAndFilterToAttributes(key1, value1, key2, value2, key3, value3, key4, value4, key5, value5);
    }

    private static Attributes sortAndFilterToAttributes(Object ... data) {
        return new AutoValue_Attributes_ArrayBackedAttributes(Attributes.sortAndFilter(data));
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final List<Object> data = new ArrayList<Object>();

        public Attributes build() {
            return Attributes.sortAndFilterToAttributes(this.data.toArray());
        }

        public Builder setAttribute(String key, AttributeValue value) {
            this.data.add(key);
            this.data.add(value);
            return this;
        }

        public Builder setAttribute(String key, String value) {
            this.data.add(key);
            this.data.add(AttributeValue.stringAttributeValue(value));
            return this;
        }

        public Builder setAttribute(String key, long value) {
            this.data.add(key);
            this.data.add(AttributeValue.longAttributeValue(value));
            return this;
        }

        public Builder setAttribute(String key, double value) {
            this.data.add(key);
            this.data.add(AttributeValue.doubleAttributeValue(value));
            return this;
        }

        public Builder setAttribute(String key, boolean value) {
            this.data.add(key);
            this.data.add(AttributeValue.booleanAttributeValue(value));
            return this;
        }

        public Builder setAttribute(String key, String ... value) {
            this.data.add(key);
            this.data.add(AttributeValue.arrayAttributeValue(value));
            return this;
        }

        public Builder setAttribute(String key, Long ... value) {
            this.data.add(key);
            this.data.add(AttributeValue.arrayAttributeValue(value));
            return this;
        }

        public Builder setAttribute(String key, Double ... value) {
            this.data.add(key);
            this.data.add(AttributeValue.arrayAttributeValue(value));
            return this;
        }

        public Builder setAttribute(String key, Boolean ... value) {
            this.data.add(key);
            this.data.add(AttributeValue.arrayAttributeValue(value));
            return this;
        }
    }

    @AutoValue
    @Immutable
    static abstract class ArrayBackedAttributes
    extends Attributes {
        ArrayBackedAttributes() {
        }

        @Override
        abstract List<Object> data();
    }
}

