/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.correlationcontext;

import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.HttpTextFormat;
import io.opentelemetry.correlationcontext.CorrelationContext;
import io.opentelemetry.correlationcontext.CorrelationContextManager;
import io.opentelemetry.correlationcontext.CorrelationsContextUtils;
import io.opentelemetry.correlationcontext.EmptyCorrelationContext;
import io.opentelemetry.correlationcontext.EntryKey;
import io.opentelemetry.correlationcontext.EntryMetadata;
import io.opentelemetry.correlationcontext.EntryValue;
import io.opentelemetry.internal.Utils;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class DefaultCorrelationContextManager
implements CorrelationContextManager {
    private static final DefaultCorrelationContextManager INSTANCE = new DefaultCorrelationContextManager();
    private static final HttpTextFormat<CorrelationContext> HTTP_TEXT_FORMAT = new NoopHttpTextFormat();

    public static CorrelationContextManager getInstance() {
        return INSTANCE;
    }

    @Override
    public CorrelationContext getCurrentContext() {
        return CorrelationsContextUtils.getCurrentCorrelationContext();
    }

    @Override
    public CorrelationContext.Builder contextBuilder() {
        return new NoopCorrelationContextBuilder();
    }

    @Override
    public Scope withContext(CorrelationContext distContext) {
        return CorrelationsContextUtils.currentContextWith(distContext);
    }

    @Override
    public HttpTextFormat<CorrelationContext> getHttpTextFormat() {
        return HTTP_TEXT_FORMAT;
    }

    @Immutable
    private static final class NoopHttpTextFormat
    implements HttpTextFormat<CorrelationContext> {
        private NoopHttpTextFormat() {
        }

        public List<String> fields() {
            return Collections.emptyList();
        }

        public <C> void inject(CorrelationContext distContext, C carrier, HttpTextFormat.Setter<C> setter) {
            Utils.checkNotNull(distContext, "distContext");
            Utils.checkNotNull(carrier, "carrier");
            Utils.checkNotNull(setter, "setter");
        }

        public <C> CorrelationContext extract(C carrier, HttpTextFormat.Getter<C> getter) {
            Utils.checkNotNull(carrier, "carrier");
            Utils.checkNotNull(getter, "getter");
            return EmptyCorrelationContext.getInstance();
        }
    }

    @Immutable
    private static final class NoopCorrelationContextBuilder
    implements CorrelationContext.Builder {
        private NoopCorrelationContextBuilder() {
        }

        @Override
        public CorrelationContext.Builder setParent(CorrelationContext parent) {
            Utils.checkNotNull(parent, "parent");
            return this;
        }

        @Override
        public CorrelationContext.Builder setNoParent() {
            return this;
        }

        @Override
        public CorrelationContext.Builder put(EntryKey key, EntryValue value, EntryMetadata tagMetadata) {
            Utils.checkNotNull(key, "key");
            Utils.checkNotNull(value, "value");
            Utils.checkNotNull(tagMetadata, "tagMetadata");
            return this;
        }

        @Override
        public CorrelationContext.Builder remove(EntryKey key) {
            Utils.checkNotNull(key, "key");
            return this;
        }

        @Override
        public CorrelationContext build() {
            return EmptyCorrelationContext.getInstance();
        }
    }
}

