/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.trace;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class DefaultTracer
implements Tracer {
    private static final DefaultTracer INSTANCE = new DefaultTracer();

    static DefaultTracer getInstance() {
        return INSTANCE;
    }

    @Override
    public SpanBuilder spanBuilder(String spanName) {
        return NoopSpanBuilder.create(spanName);
    }

    private DefaultTracer() {
    }

    private static final class NoopSpanBuilder
    implements SpanBuilder {
        @Nullable
        private SpanContext spanContext;

        static NoopSpanBuilder create(String spanName) {
            return new NoopSpanBuilder(spanName);
        }

        @Override
        public Span startSpan() {
            if (this.spanContext == null) {
                this.spanContext = Span.current().getSpanContext();
            }
            return Span.wrap(this.spanContext);
        }

        @Override
        public NoopSpanBuilder setParent(Context context) {
            Objects.requireNonNull(context, "context");
            this.spanContext = Span.fromContext(context).getSpanContext();
            return this;
        }

        @Override
        public NoopSpanBuilder setNoParent() {
            this.spanContext = SpanContext.getInvalid();
            return this;
        }

        @Override
        public NoopSpanBuilder addLink(SpanContext spanContext) {
            return this;
        }

        @Override
        public NoopSpanBuilder addLink(SpanContext spanContext, Attributes attributes) {
            return this;
        }

        @Override
        public NoopSpanBuilder setAttribute(String key, String value) {
            Objects.requireNonNull(key, "key");
            return this;
        }

        @Override
        public NoopSpanBuilder setAttribute(String key, long value) {
            Objects.requireNonNull(key, "key");
            return this;
        }

        @Override
        public NoopSpanBuilder setAttribute(String key, double value) {
            Objects.requireNonNull(key, "key");
            return this;
        }

        @Override
        public NoopSpanBuilder setAttribute(String key, boolean value) {
            Objects.requireNonNull(key, "key");
            return this;
        }

        @Override
        public <T> NoopSpanBuilder setAttribute(AttributeKey<T> key, T value) {
            Objects.requireNonNull(key, "key");
            Objects.requireNonNull(value, "value");
            return this;
        }

        @Override
        public NoopSpanBuilder setSpanKind(Span.Kind spanKind) {
            return this;
        }

        @Override
        public NoopSpanBuilder setStartTimestamp(long startTimestamp, TimeUnit unit) {
            Utils.checkArgument(startTimestamp >= 0L, "Negative startTimestamp");
            return this;
        }

        private NoopSpanBuilder(String name) {
            Objects.requireNonNull(name, "name");
        }
    }
}

